/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.devkit.generation.api.AbstractBaseProjectVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.generation.studio.utils.JaxbUnmarshaller;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.NamespaceType;
import org.mule.devkit.model.studio.libraries.RequiredLibraries;
import org.xml.sax.SAXException;

public class ConfigRequiredLibrariesVerifier
extends AbstractBaseProjectVerifier {
    private static final String REQUIRED_LIBS_SCHEMA = "config-required-libs-schema.xsd";
    private static final String[] allowedExtensions = new String[]{"xml"};
    private Pattern requiredLibsNamePatter = Pattern.compile(".+-required-libs.xml");
    private Module module;

    public boolean shouldVerify(List modules) {
        return true;
    }

    public List processableModules(List modules) {
        return modules;
    }

    public void verify(List modules, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setGatherer(gatherer);
        this.module = (Module)modules.get(0);
        File requiredLibsDir = new File(this.ctx().getMavenInformation().getBuildDirectory(), "src/main/resources/META-INF");
        if (requiredLibsDir.exists()) {
            Iterator libsFilesIt = FileUtils.iterateFiles((File)requiredLibsDir, (String[])allowedExtensions, (boolean)false);
            while (libsFilesIt.hasNext()) {
                this.verifyXml((File)libsFilesIt.next(), gatherer);
            }
        }
    }

    private void verifyXml(File xml, NotificationGatherer gatherer) {
        if (this.requiredLibsNamePatter.matcher(xml.getName()).matches()) {
            String error;
            InputStream schema = ConfigRequiredLibrariesVerifier.class.getClassLoader().getResourceAsStream(REQUIRED_LIBS_SCHEMA);
            try {
                this.verifyXmlWithSchema(schema, xml);
                error = this.verifyElementHasLibrariesDeclaration(xml);
            }
            catch (SAXException e) {
                error = e.getMessage();
            }
            catch (IOException e) {
                error = e.getMessage();
            }
            if (!StringUtils.isBlank((String)error)) {
                gatherer.error((Identifiable)this.module, (DevkitNotification)Message.INVALID_REQUIRED_LIBS_DEFINITION, new Object[]{xml.getName(), error});
            }
        }
    }

    private String verifyElementHasLibrariesDeclaration(File xml) {
        String error = "";
        JAXBElement root = (JAXBElement)JaxbUnmarshaller.unmarshallXml(xml.getPath(), NamespaceType.class);
        if (!((RequiredLibraries)((NamespaceType)root.getValue()).getRequiredLibs().getValue()).hasElements()) {
            error = "No required libraries found in element 'require'";
        }
        return error;
    }

    private void verifyXmlWithSchema(InputStream schemaSource, File xml) throws IOException, SAXException {
        Schema schema;
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schema = factory.newSchema(new StreamSource(schemaSource));
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Invalid input schema for xml verification utility method", e);
        }
        schema.newValidator().validate(new StreamSource(xml));
    }
}

