/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.devkit.generation.studio;

import org.mule.common.MuleVersion;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;


public class StudioSiteXmlGenerator extends AbstractMuleStudioGenerator implements MultiModuleGenerator {
    private static final String CATEGORY_XML = "category.xml";

    public static final String STUDIO_PREFIX = "org.mule.tooling.ui.extension.";

    private static final List<Product> PRODUCES = Arrays.asList(Product.STUDIO_SITE_XML, Product.STUDIO_FEATURE_NAME);

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) {
                return true;
            }
        }

        return false;
    }

    @Override
    public List<Module> processableModules(List<Module> modules) {
        List<Module> processableModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) {
                processableModules.add(module);
            }
        }
        return processableModules;
    }

    @Override
    public void generate(List<Module> modules) throws GenerationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();

            Element site = document.createElement("site");
            document.appendChild(site);

            Element feature = document.createElement("feature");

            MuleVersion version = getMaxVersion(modules);
            String featureId = STUDIO_PREFIX + removeMuleModulePrefix(ctx().getMavenInformation().getArtifactId()) + (version != null ? "."  + version.toCompleteNumericVersion() : "");
            feature.setAttribute("id", featureId);
            ctx().registerProduct(Product.STUDIO_FEATURE_NAME, featureId);

            String category1 = ctx().getMavenInformation().getCategory();

            String categoryAsString = getCategoryAsString(modules.get(0), category1);

            Element category = document.createElement("category");
            category.setAttribute("name", ctx().getMavenInformation().getGroupId());

            feature.appendChild(category);

            Element categoryDef = document.createElement("category-def");
            categoryDef.setAttribute("name", ctx().getMavenInformation().getGroupId());
            categoryDef.setAttribute("label", categoryAsString);
            site.appendChild(feature);
            site.appendChild(categoryDef);

            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();

            DOMSource source = new DOMSource(document);
            String featureFile = CATEGORY_XML;
            StreamResult result = new StreamResult(ctx().getCodeModel().getCodeWriter().openBinary(null, featureFile));
            transformer.transform(source, result);

            ctx().registerProduct(Product.STUDIO_SITE_XML, featureFile);

        } catch (Exception e) {
            throw new GenerationException("Error generating Mule Studio plugin.xml", e);
        }
    }

    private String getCategoryAsString(Module module, String category1) {
        String categoryAsString;
        if (category1 == null) {
            if (module instanceof ManagedConnectionModule || module instanceof OAuthModule) {
                categoryAsString = "Mule Cloud Connectors";
            } else {
                categoryAsString = "Mule Modules";
            }
        } else {
            categoryAsString = category1;
        }
        return categoryAsString;
    }


    private String removeMuleModulePrefix(String artifactId) {
        String muleModulePrefix = "mule-module-";
        if (artifactId.startsWith(muleModulePrefix)) {
            return artifactId.substring(muleModulePrefix.length());
        }
        return artifactId;
    }
}
