/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.List;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.BaseStudioXmlBuilder;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.collection.CollectionAttributeType;
import org.mule.devkit.model.studio.collection.ListOfMapNoExpressionType;
import org.mule.devkit.model.studio.collection.StringListNoExpressionType;
import org.mule.devkit.model.studio.collection.StringMapNoExpressionType;
import org.mule.devkit.utils.NameUtils;

public abstract class GlobalTypeBuilder
extends BaseStudioXmlBuilder {
    public GlobalTypeBuilder(Context context, Method executableElement, Module module) {
        super(context, executableElement, module);
    }

    public GlobalTypeBuilder(Context context, Module module) {
        super(context, module);
    }

    protected abstract List<AttributeCategory> getAttributeCategories();

    protected abstract String getDescriptionBasedOnType();

    protected abstract String getExtendsBasedOnType();

    protected abstract String getLocalIdBasedOnType();

    protected abstract String getNameDescriptionBasedOnType();

    protected abstract String getImage();

    protected abstract String getIcon();

    protected abstract Boolean isAbstract();

    public GlobalType build() {
        GlobalType globalType = new GlobalType();
        globalType.setImage(this.getImage());
        globalType.setIcon(this.getIcon());
        globalType.setCaption(this.getCaptionBasedOnType());
        globalType.setLocalId(this.getLocalIdBasedOnType());
        globalType.setExtends(this.getExtendsBasedOnType());
        globalType.setDescription(this.getDescriptionBasedOnType());
        globalType.setAbstract(this.isAbstract());
        globalType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().addAll(this.getAttributeCategories());
        return globalType;
    }

    protected AttributeType createNameAttributeType() {
        AttributeType name = new AttributeType();
        name.setName("name");
        name.setCaption(this.helper.formatCaption("Name"));
        name.setDescription(this.helper.formatDescription(this.getNameDescriptionBasedOnType()));
        name.setRequired(Boolean.valueOf(true));
        return name;
    }

    protected String getCaptionBasedOnType() {
        return "General";
    }

    protected AttributeType handleCollectionVariable(Variable parameter) {
        StringListNoExpressionType attributeType;
        if (this.helper.isListOfMaps(parameter)) {
            ListOfMapNoExpressionType objectListAttributeType = new ListOfMapNoExpressionType();
            objectListAttributeType.setRequired(Boolean.valueOf(!parameter.isOptional()));
            objectListAttributeType.setListName(NameUtils.uncamel((String)parameter.getName()));
            objectListAttributeType.setInnerName(NameUtils.uncamel((String)("inner-" + NameUtils.singularize((String)parameter.getName()))));
            objectListAttributeType.setSupportsExpressions(Boolean.valueOf(false));
            this.setCommonCollectionAttributes(parameter, (CollectionAttributeType)objectListAttributeType);
            attributeType = objectListAttributeType;
        } else if (this.helper.isSimpleList(parameter) || this.helper.isSimpleSet(parameter)) {
            StringListNoExpressionType stringListAttributeType = new StringListNoExpressionType();
            stringListAttributeType.setListName(NameUtils.uncamel((String)parameter.getName()));
            stringListAttributeType.setSupportsExpressions(Boolean.valueOf(false));
            this.setCommonCollectionAttributes(parameter, (CollectionAttributeType)stringListAttributeType);
            attributeType = stringListAttributeType;
        } else {
            StringMapNoExpressionType stringMapAttributeType = new StringMapNoExpressionType();
            stringMapAttributeType.setMapName(NameUtils.uncamel((String)parameter.getName()));
            stringMapAttributeType.setSupportsExpressions(Boolean.valueOf(false));
            this.setCommonCollectionAttributes(parameter, (CollectionAttributeType)stringMapAttributeType);
            attributeType = stringMapAttributeType;
        }
        attributeType.setRequired(Boolean.valueOf(!parameter.isOptional()));
        return attributeType;
    }

    @Override
    protected AttributeType createAttributeTypeFromVariable(Variable<?> variable) {
        AttributeType type = super.createAttributeTypeFromVariable(variable);
        type.setSupportsExpressions(Boolean.valueOf(false));
        return type;
    }
}

