/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor.callback;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.callback.AbstractCallbackNestedElementBuilder;
import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.studio.AbstractElementType;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.NestedElementType;
import org.mule.devkit.model.studio.StringAttributeType;

public class OAuthConfigNestedElementsBuilder
extends AbstractCallbackNestedElementBuilder {
    public static final String OAUTH_CALLBACK_CONFIG_ELEMENT = "oauth-callback-config";
    public static final String OAUTH_STORE_CONFIG_ELEMENT = "oauth-store-config";

    public OAuthConfigNestedElementsBuilder(Context context, Module module) {
        super(context, module);
    }

    public List<JAXBElement<? extends AbstractElementType>> build() {
        ArrayList<JAXBElement<? extends AbstractElementType>> nesteds = new ArrayList<JAXBElement<? extends AbstractElementType>>(2);
        nesteds.add(this.objectFactory.createNested(this.createCallbackConfigNestedElementType(OAUTH_CALLBACK_CONFIG_ELEMENT)));
        nesteds.add(this.objectFactory.createNested(this.createStoreConfigNestedElementType()));
        return nesteds;
    }

    @Override
    protected void addCustomElements(NestedElementType nestedElementType) {
        OAuthCapability oAuthCapability = OAuth2StrategyUtilsResolver.getOAuthCapability((Module)this.module);
        if (oAuthCapability.getOAuthVersion() == OAuthVersion.V2) {
            StringAttributeType defaultAccessTokenId = this.helper.createStringAttributeType("Default Access Token Id", "A Mule Expression to use as access token id", "defaultAccessTokenId");
            nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)defaultAccessTokenId));
        }
    }

    private NestedElementType createStoreConfigNestedElementType() {
        NestedElementType nestedElementType = new NestedElementType();
        nestedElementType.setLocalId(OAUTH_STORE_CONFIG_ELEMENT);
        nestedElementType.setAbstract(Boolean.valueOf(true));
        nestedElementType.setCaption("");
        nestedElementType.setDescription("Configuration element for storage of access tokens");
        StringAttributeType objectStoreRefAttribute = this.helper.createStringAttributeType("Object store reference", "Object store reference", "objectStore-ref");
        nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)objectStoreRefAttribute));
        return nestedElementType;
    }
}

