/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.studio.editor.globalcloudconnector;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.VariableComparator;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.OAuth2Component;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.studio.*;
import org.mule.util.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GlobalCloudConnectorOAuthBuilder extends GlobalCloudConnectorTypeBuilder {

    OAuth2Component oAuth2Component;

    public GlobalCloudConnectorOAuthBuilder(Context context, Module module, OAuth2Component oAuth2Component, boolean abstrac7, String globalRefId) {
        super(context, module, abstrac7, globalRefId);
        this.oAuth2Component = oAuth2Component;
    }

    @Override
    protected void buildConnectivityTestingAttr(GlobalType globalCloudConnector) {
        setConnectivityTestingAttribute(globalCloudConnector, oAuth2Component.testConnectivityMethod());
    }

    @Override
    protected void buildMetaDataAttr(GlobalType globalCloudConnector, boolean dynamicMetadata) {
        //as OAuth2 does not supports dynamic datasense, we make sure the editors will generate static for this global element
        super.buildMetaDataAttr(globalCloudConnector, false);
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return oAuth2Component.configElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return helper.getFormattedCaption(module).concat(": ").concat(oAuth2Component.friendlyName());
    }

    @Override
    protected List<Field> getConfigurableFieldsSorted() {
        List<Field> configurableFields = oAuth2Component.getConfigurableFields();
        configurableFields.removeAll(getOAuthConfigurableFields());
        configurableFields.addAll(module.getConfigurableFields());
        Collections.sort(configurableFields, new VariableComparator());
        return configurableFields;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        String javaDocSummary = "Global " + oAuth2Component.friendlyName() + " configuration information.";
        javaDocSummary += oAuth2Component.getJavaDocSummary() != null ? " " + oAuth2Component.getJavaDocSummary() : "";
        return helper.formatDescription(javaDocSummary);
    }

    @Override
    protected boolean hasConnectionMethod() {
        return false;
    }

    @Override
    protected ConnectMethod connectMethod(){
        throw new RuntimeException("This should have not happen, as this module was not initialized for a managed connection management but rather an OAuth component scenario");
    }

    @Override
    protected void createOAuthConfig(Map<String,Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        buildOAuthConfig(groupsByName, attributeCategoriesByName);
    }

    @Override
    protected List<AttributeType> getConnectionAttributes() {
        return getConnectionAttributes(getOAuthConfigurableFields());
    }

    @Override
    protected void createMetaDataAttributes(Map<String,Group> groupsByName, Map<String,AttributeCategory> attributeCategoriesByName) {
        //does nothing
    }

    private List<Field> getOAuthConfigurableFields() {
        List<Field> oauthFields = new ArrayList<>();
        oauthFields.add(oAuth2Component.getConsumerKeyField());
        oauthFields.add(oAuth2Component.getConsumerSecretField());
        if (oAuth2Component.getScopeField() != null){
            oauthFields.add(oAuth2Component.getScopeField());
        }

        return oauthFields;
    }
}
