/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.*;
import org.mule.devkit.utils.NameUtils;

import javax.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class NestedsBuilder extends BaseStudioXmlBuilder implements StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>> {
    public NestedsBuilder(Context ctx, Module module) {
        super(ctx, module);
    }

    @Override
    public List<JAXBElement<? extends AbstractElementType>> build() {
        List<JAXBElement<? extends AbstractElementType>> nesteds = new ArrayList<JAXBElement<? extends AbstractElementType>>();

        ComplexTypeParameterVisitor complexTypeParameterVisitor = new ComplexTypeParameterVisitor();
        module.accept(complexTypeParameterVisitor);

        for (Variable<?> complexTypeParameter : complexTypeParameterVisitor.getRegisteredComplexTypes()) {
            if (!complexTypeParameter.isRefOnly()) {
                if (complexTypeParameter.isArrayOrListOfComplexType(false)) {
                    // List or Array
                    nesteds.add(objectFactory.createNested(generateNestedForArrayOrListOfComplexType(complexTypeParameter)));
                    // POJO
                    nesteds.add(objectFactory.createNested(generateNestedForArrayOrListOfComplexGenericType(complexTypeParameter)));
                } else {
                    nesteds.add(objectFactory.createNested(generateNestedForType(complexTypeParameter)));
                }
            }
        }

        return nesteds;
    }

    private Type getGenericType(Variable identifiable) {

        java.util.List<Type> variableTypeParameters = identifiable.getTypeArguments();
        if (variableTypeParameters.size() != 0 && variableTypeParameters.get(0) != null) {
            Type genericType = variableTypeParameters.get(0);
            if (genericType.isComplexTypeWithGetterAndSetter(true)) {
                return genericType;
            }
        }

        return null;
    }

    /*
     * Just for List of POJOs. Avoiding the reference as the use case makes no sense at all:
     * Why will I create an internal POJO inside my Mule app and pass it as a reference when
     * I can just add the values in a very nice and tidy way
     */
    private NestedElementType generateNestedForArrayOrListOfComplexGenericType(Variable<?> variable) {
        NestedElementType nestedElementType = new NestedElementType();
        String genericTypeName = NameUtils.singularize(variable.getName());
        nestedElementType.setLocalId(NameUtils.uncamel(genericTypeName));
        nestedElementType.setAbstract(false);
        nestedElementType.setCaption(NameUtils.friendlyNameFromCamelCase(genericTypeName));
        nestedElementType.setDescription("");
        nestedElementType.setXmlname(NameUtils.uncamel(genericTypeName));

        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(helper.formatCaption(NameUtils.friendlyNameFromCamelCase(genericTypeName)));
        attributeCategory.setDescription(helper.formatDescription(variable.getJavaDocSummary()));

        Group group = new Group();
        group.setCaption(helper.formatCaption(NameUtils.friendlyNameFromCamelCase(genericTypeName)));
        group.setId("genericType" + NameUtils.camel(genericTypeName) + "Group");

        attributeCategory.getGroup().add(group);

        Type genericType = getGenericType(variable);
        if (genericType != null) {
            for (Field<Type> field : genericType.getFields()) {
                // Ignore constants and static fields (DEVKIT-270)
                // This condifition should be in sync with SchemaBuilder skip(Field) method
                if(field.hasGetter() && field.hasSetter() && !field.shouldBeIgnored()) {
                    JAXBElement<? extends AttributeType> jaxbElement = createJaxbElement(field);
                    // No need (and no reason!) to annotate with @Optional inside complex types used as operation arguments
                    if (jaxbElement == null) continue;  //TODO: This is just for the moment, check why can be a null jaxbElement
                    jaxbElement.getValue().setRequired(false); //TODO: Should come from metadatda (annotations) in the POJO
                    group.getRegexpOrEncodingOrModeSwitch().add(jaxbElement);
                }
            }
        }

        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createAttributeCategory(attributeCategory));
        return nestedElementType;
    }

    private NestedElementType generateNestedForArrayOrListOfComplexType(Variable<?> variable) {
        NestedElementType nestedElementType = new NestedElementType();

        nestedElementType.setLocalId(NameUtils.uncamel(variable.getName()));
        nestedElementType.setAbstract(false);
        nestedElementType.setCaption(NameUtils.friendlyNameFromCamelCase(variable.getName()));
        nestedElementType.setDescription("");
        nestedElementType.setXmlname(NameUtils.uncamel(variable.getName()));

        NestedElementReference childElement = new NestedElementReference();
        String defaultValue = variable.getDefaultValue();
        if (defaultValue != null) {
            childElement.setDefaultValue(defaultValue);
        }
        childElement.setName(MuleStudioEditorXmlGenerator.URI_PREFIX + moduleName + '/' + NameUtils.uncamel(NameUtils.singularize(variable.getName())));
        childElement.setCaption(helper.getFormattedCaption(variable));
        childElement.setAllowMultiple(true); // List
        childElement.setPositional(true); // Position of elements matter in the case of a list
        childElement.setInplace(true);
        childElement.setJavaType(variable.getJavaType());
        childElement.setRequired(!variable.isOptional());

        Group group = new Group();
        group.setId(variable.getName() + "ListGroup");
        group.setCaption(helper.formatCaption(NameUtils.friendlyNameFromCamelCase(variable.getName())));


        group.getRegexpOrEncodingOrModeSwitch().add(objectFactory.createGroupChildElement(childElement));

        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroup(group));

        return nestedElementType;

    }

    private NestedElementType generateNestedForType(Variable<?> variable) {
        NestedElementType nestedElementType = new NestedElementType();

        nestedElementType.setLocalId(NameUtils.uncamel(variable.getName()));
        nestedElementType.setAbstract(false);
        nestedElementType.setCaption("");
        nestedElementType.setDescription("");
        nestedElementType.setXmlname(NameUtils.uncamel(variable.getName()));

        Booleantype refBoolean = new Booleantype();
        refBoolean.setDescription("Provide a reference to a bean or use an expression");
        refBoolean.setCaption("Reference or expression");
        refBoolean.setName("useReference");
        refBoolean.setFillLine(true);
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupRadioBoolean(refBoolean));

        AttributeType stringAttributeType = generateRefAttribute(variable);
        stringAttributeType.setControlled("useReference");
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createNestedElementTypeString(stringAttributeType));

        Booleantype radio2 = new Booleantype();
        radio2.setDescription("Define this element's attributes");
        radio2.setCaption("Define attributes");
        radio2.setName("complex");
        radio2.setFillLine(true);
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupRadioBoolean(radio2));

        for (Field<Type> field : getAllFields(variable.asType())) {
            // Ignore constants and static fields (DEVKIT-270)
            // This condition should be in sync with SchemaBuilder skip(Field) method
            if(field.hasGetter() && field.hasSetter() && !field.shouldBeIgnored()) {
                JAXBElement<? extends AttributeType> jaxbElement = createJaxbElement(field);
                // No need (and no reason!) to annotate with @Optional inside complex types used as operation arguments
                if (jaxbElement == null) continue;  //TODO: This is just for the moment, check why can be a null jaxbElement
                jaxbElement.getValue().setRequired(false);
                jaxbElement.getValue().setControlled("complex");
                nestedElementType.getRegexpOrEncodingOrString().add(jaxbElement);
            }
        }

        return nestedElementType;
    }

    private List<Field<Type>> getAllFields(Type type){
        if (!type.hasSuperClass()){
            return type.getFields();
        }
        List<Field<Type>> fields = new LinkedList<>();
        fields.addAll(getAllFields(type.getSuperClass()));
        fields.addAll(type.getFields());
        return fields;
    }

    private AttributeType generateRefAttribute(Variable<?> variable) {
        AttributeType stringAttributeType = new AttributeType();
        stringAttributeType.setName("ref");
        stringAttributeType.setCaption(helper.getFormattedCaption(variable));
        stringAttributeType.setDescription("");
        return stringAttributeType;
    }
}
