/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.MultiModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.verifiers.util.MulePathResolver;

public class MultiModuleStudioPackageVerifier
implements MultiModuleAnnotationVerifier {
    private static final int LIGHT_THEME_LARGE_SIZE = 26;
    private static final int LIGHT_THEME_SMALL_SIZE = 16;
    private static final int CLASSIC_THEME_LARGE_WIDTH_SIZE = 48;
    private static final int CLASSIC_THEME_LARGE_HEIGHT_SIZE = 32;
    private static final int CLASSIC_THEME_SMALL_WIDTH_SIZE = 24;
    private static final int CLASSIC_THEME_SMALL_HEIGHT_SIZE = 16;

    public boolean shouldVerify(List<Module> modules) {
        return true;
    }

    public List<Module> processableModules(List<Module> modules) {
        return modules;
    }

    public void verify(List<Module> modules, NotificationGatherer gatherer) throws AnnotationVerificationException {
        if (!this.hasConnectorOrModule(modules)) {
            gatherer.error((Identifiable)modules.get(0), (DevkitNotification)Message.DEVKIT_PACKAGE_PROPERTY_REQUIRES_AT_LEAST_ONE_MODULE, new Object[0]);
        } else {
            this.verifyModules(modules, gatherer);
        }
    }

    private void verifyModules(List<Module> modules, NotificationGatherer gatherer) {
        List<Module> modulesToBeValidated = this.getModuleByKind(modules, Arrays.asList(ModuleKind.CONNECTOR, ModuleKind.GENERIC));
        for (Module module : modulesToBeValidated) {
            this.verifyIcon(module, gatherer);
        }
    }

    private void verifyIcon(Module module, NotificationGatherer gatherer) {
        if (module.hasProcessors() || this.hasWsdlComponent(module)) {
            this.checkIcon(String.format("../../../icons/theme.classic/%s-connector-large.png", module.getModuleName()), 32, 48, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.classic/%s-connector-small.png", module.getModuleName()), 16, 24, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.light/%s-connector-large.png", module.getModuleName()), 26, 26, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.light/%s-connector-small.png", module.getModuleName()), 16, 16, module, gatherer);
        }
        if (module.hasSources()) {
            this.checkIcon(String.format("../../../icons/theme.classic/%s-endpoint-large.png", module.getModuleName()), 32, 48, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.classic/%s-endpoint-small.png", module.getModuleName()), 16, 24, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.light/%s-endpoint-large.png", module.getModuleName()), 26, 26, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.light/%s-endpoint-small.png", module.getModuleName()), 16, 16, module, gatherer);
        }
        if (module.hasTransformers()) {
            this.checkIcon(String.format("../../../icons/theme.classic/%s-transformer-large.png", module.getModuleName()), 32, 48, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.classic/%s-transformer-small.png", module.getModuleName()), 16, 24, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.light/%s-transformer-large.png", module.getModuleName()), 26, 26, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.light/%s-transformer-small.png", module.getModuleName()), 16, 16, module, gatherer);
        }
        if (this.hasContainer(module)) {
            this.checkIcon(String.format("../../../icons/theme.classic/%s-container-large.png", module.getModuleName()), 32, 48, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.classic/%s-container-small.png", module.getModuleName()), 16, 24, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.light/%s-container-large.png", module.getModuleName()), 26, 26, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.light/%s-container-small.png", module.getModuleName()), 16, 16, module, gatherer);
        }
        if (this.hasContainerList(module)) {
            this.checkIcon(String.format("../../../icons/theme.classic/%s-flow-large.png", module.getModuleName()), 32, 48, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.classic/%s-flow-small.png", module.getModuleName()), 16, 24, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.light/%s-flow-large.png", module.getModuleName()), 26, 26, module, gatherer);
            this.checkIcon(String.format("../../../icons/theme.light/%s-flow-small.png", module.getModuleName()), 16, 16, module, gatherer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkIcon(String fileName, int height, int width, Module module, NotificationGatherer gatherer) {
        FileInputStream inputStream;
        block5: {
            File fileToCopy = MulePathResolver.getFileResolvingPackages((Module)module, (String)fileName);
            if (!fileToCopy.exists()) {
                gatherer.warn((Identifiable)module, (DevkitNotification)Message.MISSING_ICON, new Object[]{module.getModuleName(), fileToCopy.getAbsolutePath()});
                return;
            }
            inputStream = null;
            try {
                inputStream = new FileInputStream(fileToCopy);
                BufferedImage image = ImageIO.read(inputStream);
                if (image.getWidth() == width && image.getHeight() == height) break block5;
                gatherer.warn((Identifiable)module, (DevkitNotification)Message.INVALID_ICON_SIZE, new Object[]{fileToCopy, width, height, image.getWidth(), image.getHeight()});
            }
            catch (IOException e) {
                try {
                    gatherer.warn((Identifiable)module, (DevkitNotification)Message.UNKNOWN_ERROR_VERIFYING_CONNECTOR_ICON, new Object[]{fileToCopy});
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                return;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return;
    }

    private List<Module> getModuleByKind(List<Module> modules, List<ModuleKind> kinds) {
        ArrayList<Module> specificModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (!kinds.contains(module.getKind())) continue;
            specificModules.add(module);
        }
        return specificModules;
    }

    private boolean hasConnectorOrModule(List<Module> modules) {
        boolean hasConnectorOrModule = false;
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            hasConnectorOrModule = true;
        }
        return hasConnectorOrModule;
    }

    private boolean hasWsdlComponent(Module module) {
        return module.manager().wsdlProviderComponent().size() > 0;
    }

    private boolean hasContainer(Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!processorMethod.isContainer()) continue;
            return true;
        }
        return false;
    }

    private boolean hasContainerList(Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!processorMethod.isContainerList()) continue;
            return true;
        }
        return false;
    }
}

