/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.List;
import java.util.Map;
import org.mule.api.annotations.Category;
import org.mule.api.annotations.Paged;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Transformer;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.BaseStudioXmlBuilder;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.connectivity.ConnectionManagementCapability;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.ContainerType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.PatternType;
import org.mule.util.StringUtils;

public class PatternTypeBuilder
extends BaseStudioXmlBuilder {
    public PatternTypeBuilder(Context context, Method method, Module module) {
        super(context, method, module);
    }

    public PatternType build() {
        PatternType patternType = this.createPatternType();
        this.fillCommonPatternType(patternType);
        if (this.method.getAnnotation(Processor.class) != null) {
            List<AttributeCategory> attributeCategories = this.processMethodParameters();
            patternType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().addAll(attributeCategories);
        }
        return patternType;
    }

    private PatternType createPatternType() {
        Object patternType = this.isContainer(this.method) ? this.getContainerType() : (this.isContainerList(this.method) ? this.getContainerListType() : this.getCommonPatternType());
        return patternType;
    }

    private boolean isContainer(Method method) {
        return method instanceof ProcessorMethod && ((ProcessorMethod)method).isContainer();
    }

    private boolean isContainerList(Method method) {
        return method instanceof ProcessorMethod && ((ProcessorMethod)method).isContainerList();
    }

    private ContainerType getContainerType() {
        ContainerType containerType = new ContainerType();
        containerType.setPathExpression("${index}");
        containerType.setAcceptedByElements("!http://www.mulesoft.org/schema/mule/core/mule");
        containerType.setTitleColor("168, 206, 226");
        containerType.getGraphicalContainer().setLocalId(this.helper.getLocalId(this.method) + "-nested");
        containerType.getGraphicalContainer().setAcceptsElements("!category:org.mule.tooling.ui.modules.core.exceptions");
        containerType.getGraphicalContainer().setShowsResponse(Boolean.valueOf(false));
        containerType.setAbstract(Boolean.valueOf(false));
        return containerType;
    }

    private PatternType getContainerListType() {
        PatternType patternType = new PatternType();
        patternType.setCausesSplit(Boolean.valueOf(true));
        patternType.setAbstract(Boolean.valueOf(false));
        return patternType;
    }

    private PatternType getCommonPatternType() {
        PatternType patternType = new PatternType();
        patternType.setAbstract(Boolean.valueOf(true));
        return patternType;
    }

    protected PatternType fillCommonPatternType(PatternType patternType) {
        patternType.setLocalId(this.helper.getLocalId(this.method));
        patternType.setCaption(this.helper.getFormattedCaption(this.method));
        if (this.method.getAnnotation(Processor.class) != null) {
            patternType.setExtends(this.helper.getUrl(this.module) + this.helper.getGlobalRefId(this.module.getModuleName()));
            String returnType = this.method.getReturnType().toString();
            if (this.method.getAnnotation(Paged.class) != null) {
                returnType = this.helper.getPagedReturnType(this.method);
            }
            patternType.setReturnType(returnType);
        } else if (this.method.getAnnotation(Transformer.class) != null) {
            patternType.setExtends(this.helper.getUrl(this.module) + "abstractTransformer");
            patternType.setDescription(this.helper.formatDescription(this.method.getJavaDocSummary()));
        }
        Category category = (Category)this.module.getAnnotation(Category.class);
        if (category != null && StringUtils.isNotBlank((String)category.name())) {
            patternType.setCategory(category.name());
        }
        patternType.setIcon(this.getIcon());
        patternType.setImage(this.getImage());
        return patternType;
    }

    protected String getImage() {
        if (this.method.getAnnotation(Transformer.class) != null) {
            return this.helper.getTransformerImage(this.module);
        }
        if (this.isContainer(this.method)) {
            return this.helper.getContainerImage(this.module);
        }
        if (this.isContainerList(this.method)) {
            return this.helper.getFlowImage(this.module);
        }
        return this.helper.getConnectorImage(this.module);
    }

    protected String getIcon() {
        if (this.method.getAnnotation(Transformer.class) != null) {
            return this.helper.getTransformerIcon(this.module);
        }
        if (this.isContainer(this.method)) {
            return this.helper.getContainerIcon(this.module);
        }
        if (this.isContainerList(this.method)) {
            return this.helper.getFlowIcon(this.module);
        }
        return this.helper.getConnectorIcon(this.module);
    }

    @Override
    protected void processConnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        ConnectionManagementCapability connectionManagementCapability = null;
        if (this.module.manager().connectionManagementOverride().isPresent()) {
            connectionManagementCapability = (ConnectionManagementCapability)this.module.manager().connectionManagementOverride().get();
        } else if (this.module instanceof ManagedConnectionModule) {
            connectionManagementCapability = (ConnectionManagementCapability)this.module;
        }
        if (connectionManagementCapability != null) {
            Group connectionAttributesGroup = new Group();
            connectionAttributesGroup.setCaption(this.helper.formatCaption("Connector Configuration Overrides"));
            connectionAttributesGroup.setId(StringUtils.uncapitalize((String)"Connector Configuration Overrides"));
            groupsByName.put("Connector Configuration Overrides", connectionAttributesGroup);
            List<AttributeType> connectionAttributes = this.getConnectionAttributes(connectionManagementCapability);
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().addAll(this.helper.createJAXBElements(connectionAttributes));
            AttributeCategory connectionAttributeCategory = new AttributeCategory();
            connectionAttributeCategory.setCaption(this.helper.formatCaption("Advanced"));
            connectionAttributeCategory.setDescription(this.helper.formatDescription("Advanced"));
            attributeCategoriesByName.put("Advanced", connectionAttributeCategory);
            connectionAttributeCategory.getGroup().add(connectionAttributesGroup);
        }
    }
}

