/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.schema;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.schema.NamespaceFilter;
import org.mule.devkit.model.schema.Schema;
import org.mule.devkit.model.schema.SchemaLocation;
import org.mule.util.IOUtils;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SchemaModel {
    private CodeWriter codeWriter;
    private List<SchemaLocation> schemaLocations;

    public SchemaModel(CodeWriter codeWriter) {
        this.codeWriter = codeWriter;
        this.schemaLocations = new ArrayList<SchemaLocation>();
    }

    public void addSchemaLocation(SchemaLocation schemaLocation) {
        this.schemaLocations.add(schemaLocation);
    }

    public void build() throws IOException {
        try {
            if (!this.schemaLocations.isEmpty()) {
                for (SchemaLocation schemaLocation : this.schemaLocations) {
                    if (schemaLocation.getSchema() == null) continue;
                    this.buildSchema(schemaLocation);
                }
                this.buildSpringHandlersFile();
                this.buildSpringSchemasFile();
            }
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSchema(SchemaLocation schemaLocation) throws JAXBException, IOException {
        OutputStream schemaStream = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Schema.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            NamespaceFilter outFilter = new NamespaceFilter("mule", "http://www.mulesoft.org/schema/mule/core", true);
            OutputFormat format = new OutputFormat();
            format.setIndent(true);
            format.setNewlines(true);
            schemaStream = this.codeWriter.openBinary(null, schemaLocation.getFileName());
            XMLWriter writer = new XMLWriter(schemaStream, format);
            outFilter.setContentHandler((ContentHandler)writer);
            marshaller.marshal((Object)schemaLocation.getSchema(), (ContentHandler)outFilter);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(schemaStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)schemaStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSpringHandlersFile() throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            OutputStream outputStream = this.codeWriter.openBinary(null, "META-INF/spring.handlers");
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            for (SchemaLocation schemaLocation : this.schemaLocations) {
                if (schemaLocation.getNamespaceHandler() == null) continue;
                String targetNamespace = schemaLocation.getTargetNamespace().replace("://", "\\://");
                outputStreamWriter.write(targetNamespace + "=" + schemaLocation.getNamespaceHandler() + "\n");
            }
            outputStreamWriter.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStreamWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)outputStreamWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSpringSchemasFile() throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            OutputStream outputStream = this.codeWriter.openBinary(null, "META-INF/spring.schemas");
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            for (SchemaLocation schemaLocation : this.schemaLocations) {
                if (schemaLocation.getFileName() == null || schemaLocation.getLocation() == null) continue;
                outputStreamWriter.write(schemaLocation.getLocation().replace("://", "\\://") + "=" + schemaLocation.getFileName() + "\n");
            }
            outputStreamWriter.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStreamWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)outputStreamWriter);
    }

    public List<SchemaLocation> getSchemaLocations() {
        return this.schemaLocations;
    }
}

