/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.api.metadata;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.devkit.api.metadata.ComposedMetaDataKey;
import org.mule.devkit.api.metadata.DefaultMetaDataKeyLevel;
import org.mule.devkit.api.metadata.MetaDataKeyLevel;
import org.mule.devkit.api.metadata.exception.InvalidBuildStateException;
import org.mule.devkit.api.metadata.exception.InvalidKeyException;
import org.mule.devkit.internal.metadata.DefaultComposedMetaDataKey;

public class ComposedMetaDataKeyBuilder {
    protected List<MetaDataKeyLevel> levels = new LinkedList<MetaDataKeyLevel>();
    protected MetaDataKeyLevel currentLevel = null;
    protected String customSeparator = "";

    protected ComposedMetaDataKeyBuilder() {
    }

    public static ComposedMetaDataKey newKey() {
        return new DefaultComposedMetaDataKey();
    }

    public static ComposedMetaDataKey newKey(String separator) {
        return new DefaultComposedMetaDataKey(separator);
    }

    public static ComposedMetaDataKeyBuilder newKeyCombination() {
        return new ComposedMetaDataKeyBuilder();
    }

    public ComposedMetaDataKeyBuilder newLevel() {
        if (this.isBuildingCombination() && !this.isBuildingLevel()) {
            this.currentLevel = new DefaultMetaDataKeyLevel();
            return this;
        }
        throw new InvalidBuildStateException("Cannot create a new MetaDataKeyLevel. Key build not in progress");
    }

    public ComposedMetaDataKeyBuilder addId(String id, String label) {
        if (this.isBuildingLevel()) {
            this.currentLevel.addId(id, label);
            return this;
        }
        throw new InvalidBuildStateException("Cannot create a new id for MetaDataKeyLevel. MetaDataKeyLevel build not in progress");
    }

    public ComposedMetaDataKeyBuilder endLevel() {
        if (this.isBuildingLevel()) {
            this.levels.add(this.currentLevel);
            this.currentLevel = null;
            return this;
        }
        throw new InvalidBuildStateException("Cannot end MetaDataKeyLevel build. Key build not in progress");
    }

    public ComposedMetaDataKeyBuilder addMultiValueLevel(MetaDataKeyLevel level) {
        if (this.isBuildingCombination()) {
            if (level != null && !level.getIds().isEmpty()) {
                this.levels.add(level);
                return this;
            }
            throw new InvalidKeyException("Levels for key cannot be null nor empty");
        }
        throw new InvalidBuildStateException("Cannot create a new MetaDataKeyLevel. Key build not in progress");
    }

    public List<ComposedMetaDataKey> build() {
        if (this.isBuildingCombination()) {
            if (this.isBuildingLevel()) {
                this.endLevel();
            }
            if (!this.levels.isEmpty()) {
                return this.buildKeyCombinationForLevels();
            }
            throw new InvalidKeyException("Key should not be empty, at least one MetaDataKeyLevel is required");
        }
        throw new InvalidBuildStateException("Cannot end ComposedMetaDataKey build. Key build not in progress");
    }

    private List<ComposedMetaDataKey> buildKeyCombinationForLevels() {
        Iterator<MetaDataKeyLevel> levelsIt = this.levels.iterator();
        MetaDataKeyLevel level = levelsIt.next();
        List<ComposedMetaDataKey> composedKeys = this.initializeKeys(level);
        while (levelsIt.hasNext()) {
            level = levelsIt.next();
            composedKeys = this.expandKeysWithLevel(level, composedKeys);
        }
        this.resetBuild();
        return composedKeys;
    }

    private void resetBuild() {
        this.levels = null;
        this.currentLevel = null;
    }

    private List<ComposedMetaDataKey> expandKeysWithLevel(MetaDataKeyLevel level, List<ComposedMetaDataKey> composedKeys) {
        if (level.getIds().isEmpty()) {
            return composedKeys;
        }
        LinkedList<ComposedMetaDataKey> expandedKeys = new LinkedList<ComposedMetaDataKey>();
        for (ComposedMetaDataKey key : composedKeys) {
            for (Map.Entry<String, String> entry : level.getIds()) {
                DefaultComposedMetaDataKey expandedKey = new DefaultComposedMetaDataKey(key);
                expandedKey.addLevel(entry.getKey(), entry.getValue());
                expandedKeys.add(expandedKey);
            }
        }
        return expandedKeys;
    }

    private List<ComposedMetaDataKey> initializeKeys(MetaDataKeyLevel level) {
        LinkedList<ComposedMetaDataKey> composedKeys = new LinkedList<ComposedMetaDataKey>();
        for (Map.Entry<String, String> entry : level.getIds()) {
            ComposedMetaDataKey key = this.customSeparator.isEmpty() ? ComposedMetaDataKeyBuilder.newKey() : ComposedMetaDataKeyBuilder.newKey(this.customSeparator);
            key.addLevel(entry.getKey(), entry.getValue());
            composedKeys.add(key);
        }
        return composedKeys;
    }

    private boolean isBuildingCombination() {
        return this.levels != null;
    }

    private boolean isBuildingLevel() {
        return this.isBuildingCombination() && this.currentLevel != null;
    }
}

