/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.internal.ws.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.regex.Pattern;
import org.mule.api.MuleEvent;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.key.property.MetaDataKeyProperty;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.devkit.internal.ws.common.EnhancedServiceDefinition;
import org.mule.devkit.internal.ws.common.WsdlAdapter;
import org.mule.devkit.internal.ws.metadata.WsdlMetaDataDescriptor;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.module.ws.consumer.WSConsumer;
import org.mule.security.oauth.callback.ProcessCallback;

public class InvokeMessageProcessor
extends DevkitBasedMessageProcessor
implements MessageProcessor,
OperationMetaDataEnabled {
    protected Object type;

    public InvokeMessageProcessor(String operationName) {
        super(operationName);
    }

    public MuleEvent doProcess(final MuleEvent event) throws Exception {
        WsdlAdapter moduleObject = (WsdlAdapter)this.findOrCreate(null, false, event);
        final String _transformedType = (String)this.evaluateAndTransform(this.getMuleContext(), event, (Type)((Object)String.class), null, this.type);
        ProcessTemplate processTemplate = ((ProcessAdapter)moduleObject).getProcessTemplate();
        Object resultPayload = processTemplate.execute((ProcessCallback)new ProcessCallback<Object, Object>(){

            public List<Class<? extends Exception>> getManagedExceptions() {
                return null;
            }

            public boolean isProtected() {
                return false;
            }

            public Object process(Object object) throws Exception {
                String operation;
                String id;
                WsdlAdapter wsdlAdapter = (WsdlAdapter)object;
                if (wsdlAdapter.singleServiceDefinitionId().isPresent()) {
                    id = (String)wsdlAdapter.singleServiceDefinitionId().get();
                    operation = _transformedType;
                } else {
                    String escapedSeparator = Pattern.quote(wsdlAdapter.wsdlSeparator());
                    String[] split = _transformedType.split(escapedSeparator);
                    id = split[0];
                    operation = split[1];
                }
                EnhancedServiceDefinition enhancedServiceDefinition = wsdlAdapter.wsResolver().enhancedServiceDefinition(id, wsdlAdapter, operation);
                WSConsumer wsConsumer = wsdlAdapter.wsResolver().wsConsumer(enhancedServiceDefinition, InvokeMessageProcessor.this.muleContext);
                MuleEvent result = wsConsumer.process(event);
                return result;
            }
        }, (MessageProcessor)this, event);
        return (MuleEvent)resultPayload;
    }

    public Result<MetaData> getInputMetaData() {
        return this.getMetaDataResult(TypeDescribingProperty.TypeScope.INPUT);
    }

    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return this.getMetaDataResult(TypeDescribingProperty.TypeScope.OUTPUT);
    }

    private Result<MetaData> getMetaDataResult(TypeDescribingProperty.TypeScope scope) {
        if (this.type == null || this.type.toString() == null) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving metadata from parameter [type] at processor invoke at connector");
        }
        DefaultMetaDataKey metaDataKey = new DefaultMetaDataKey(this.type.toString(), null);
        metaDataKey.addProperty((MetaDataKeyProperty)new TypeDescribingProperty(scope, "invoke"));
        Result<MetaData> genericMetaData = this.getGenericMetaData((MetaDataKey)metaDataKey);
        return genericMetaData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {
        try {
            WsdlMetaDataDescriptor invokeMessageProcessorMetaDataDescriptor = new WsdlMetaDataDescriptor();
            WsdlAdapter moduleObject = (WsdlAdapter)this.findOrCreate(null, false, null);
            try {
                Result<MetaData> metadata = invokeMessageProcessorMetaDataDescriptor.getMetaData(metaDataKey, moduleObject);
                if (Result.Status.FAILURE.equals((Object)metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult(null, Result.Status.FAILURE, "There was an error processing metadata at WsdlConnector at invoke retrieving was successful but result is null");
                }
                return metadata;
            }
            catch (Exception e) {
                return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
            }
        }
        catch (ClassCastException cast) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        }
        catch (ConfigurationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (RegistrationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (InstantiationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
    }

    public void setType(Object value) {
        this.type = value;
    }
}

