/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.internal.ws.common;

import com.ibm.wsdl.extensions.schema.SchemaSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;

public class WsdlUtils {
    public static String[] getServiceNames(Definition wsdlDefinition) {
        Map services;
        ArrayList<String> serviceNames = new ArrayList<String>();
        if (wsdlDefinition != null && (services = wsdlDefinition.getServices()) != null) {
            for (QName name : services.keySet()) {
                serviceNames.add(name.getLocalPart());
            }
        }
        return serviceNames.toArray(new String[serviceNames.size()]);
    }

    public static String[] getPortNames(Service service) {
        ArrayList names = new ArrayList();
        if (service != null && service.getPorts() != null) {
            names.addAll(service.getPorts().keySet());
        }
        return names.toArray(new String[names.size()]);
    }

    public static String[] getOperationNames(Port port) {
        if (WsdlUtils.isAnyNull(port)) {
            return null;
        }
        ArrayList<String> operationNames = new ArrayList<String>();
        List bindingOperations = port.getBinding().getBindingOperations();
        for (BindingOperation operation : bindingOperations) {
            operationNames.add(operation.getName());
        }
        return operationNames.toArray(new String[operationNames.size()]);
    }

    public static Service getService(String wsdlPath, String wsdlService) {
        Definition def;
        if (WsdlUtils.isAnyNull(wsdlPath, wsdlService)) {
            return null;
        }
        if (StringUtils.isNotBlank((String)wsdlPath) && StringUtils.isNotBlank((String)wsdlService) && (def = WsdlUtils.parseWSDL(wsdlPath)) != null) {
            return WsdlUtils.getService(def, wsdlService);
        }
        return null;
    }

    public static Port getPort(String wsdlLocation, String selectedService, String selectedPort) {
        if (WsdlUtils.isAnyNull(wsdlLocation, selectedService, selectedPort)) {
            return null;
        }
        Service service = WsdlUtils.getService(wsdlLocation.trim(), selectedService);
        if (service != null && StringUtils.isNotBlank((String)selectedPort)) {
            return service.getPort(selectedPort.trim());
        }
        return null;
    }

    public static Port getPort(Service service, String portId) {
        if (WsdlUtils.isAnyNull(service, portId)) {
            return null;
        }
        if (StringUtils.isNotBlank((String)portId)) {
            return service.getPort(portId.trim());
        }
        return null;
    }

    public static Service getService(Definition def, String wsdlService) {
        if (WsdlUtils.isAnyNull(def, wsdlService)) {
            return null;
        }
        if (def != null) {
            return def.getService(new QName(def.getTargetNamespace(), wsdlService));
        }
        return null;
    }

    private static boolean isAnyNull(Object ... parameters) {
        for (Object parameter : parameters) {
            if (parameter != null) continue;
            return true;
        }
        return false;
    }

    public static Definition parseWSDL(String wsdlLocation) {
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
            registry.registerSerializer(Types.class, new QName("http://www.w3.org/2001/XMLSchema", "schema"), (ExtensionSerializer)new SchemaSerializer());
            QName header = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "header");
            registry.registerDeserializer(MIMEPart.class, header, registry.queryDeserializer(BindingInput.class, header));
            registry.registerSerializer(MIMEPart.class, header, registry.querySerializer(BindingInput.class, header));
            Class<?> clazz = registry.createExtension(BindingInput.class, header).getClass();
            registry.mapExtensionTypes(MIMEPart.class, header, clazz);
            WSDLReader wsdlReader = factory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            wsdlReader.setExtensionRegistry(registry);
            Definition definition = wsdlReader.readWSDL(wsdlLocation);
            return definition;
        }
        catch (WSDLException e) {
            throw new RuntimeException("Something went wrong... ", e);
        }
    }
}

