/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.internal.ws.metadata.utils;

import com.google.common.base.Optional;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.mule.devkit.internal.ws.common.WsdlUtils;
import org.mule.devkit.internal.ws.metadata.WsdlSchemaUtils;
import org.mule.devkit.internal.ws.metadata.utils.InputOperationResolver;
import org.mule.devkit.internal.ws.metadata.utils.OperationIOResolver;
import org.mule.devkit.internal.ws.metadata.utils.OutputOperationResolver;
import org.mule.devkit.internal.ws.model.WrongParametrizationException;

public class InvokeWsdlResolver {
    private OperationIOResolver operationIOResolver;
    private Definition definition;
    private List<String> schemas;
    private Service service;
    private Port port;
    private Message message;
    private Part messagePart;
    private Operation operation;
    List<SOAPHeader> operationHeaders;

    public InvokeWsdlResolver(OperationMode operationMode, String wsdlLocation, String serviceName, String portName, String operationName) throws TransformerException {
        this.verifyInput(wsdlLocation, serviceName, portName, operationName);
        this.initialize(operationMode, wsdlLocation, serviceName, portName, operationName);
    }

    private void initialize(OperationMode operationMode, String wsdlLocation, String serviceName, String portName, String operationName) throws TransformerException {
        this.operationIOResolver = operationMode == OperationMode.INPUT ? new InputOperationResolver() : new OutputOperationResolver();
        this.definition = WsdlUtils.parseWSDL(wsdlLocation);
        this.schemas = WsdlSchemaUtils.getSchemas(this.definition);
        this.service = this.definition.getService(new QName(this.definition.getTargetNamespace(), serviceName));
        this.port = this.service.getPort(portName);
        Binding binding = this.port.getBinding();
        PortType portType = binding.getPortType();
        this.operation = portType.getOperation(operationName, null, null);
        this.message = this.operationIOResolver.getMessage(this.operation);
        BindingOperation bindingOperation = binding.getBindingOperation(operationName, null, null);
        this.operationHeaders = this.operationIOResolver.getHeaders(bindingOperation);
        this.messagePart = this.resolveMessagePart(bindingOperation);
    }

    private Part resolveMessagePart(BindingOperation bindingOperation) {
        Map parts = this.message.getParts();
        if (!parts.isEmpty()) {
            if (parts.size() == 1) {
                Object firstValueKey = parts.keySet().toArray()[0];
                return (Part)parts.get(firstValueKey);
            }
            Optional<String> bodyPartNameOptional = this.operationIOResolver.getBodyPartName(bindingOperation);
            if (bodyPartNameOptional.isPresent()) {
                return (Part)parts.get(bodyPartNameOptional.get());
            }
            return null;
        }
        return null;
    }

    private void verifyInput(String wsdlLocation, String serviceName, String portName, String operationName) {
        if (this.isAnyNull(wsdlLocation, serviceName, portName, operationName)) {
            throw new WrongParametrizationException("All parameters must be not null nor empty string when initializing " + InvokeWsdlResolver.class.getSimpleName());
        }
    }

    private boolean isAnyNull(Object ... parameters) {
        for (Object parameter : parameters) {
            if (parameter != null) continue;
            return true;
        }
        return false;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public Service getService() {
        return this.service;
    }

    public Port getPort() {
        return this.port;
    }

    public Message getMessage() {
        return this.message;
    }

    public Part getMessagePart() {
        return this.messagePart;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public List<SOAPHeader> getOperationHeaders() {
        return this.operationHeaders;
    }

    public static enum OperationMode {
        INPUT,
        OUTPUT;

    }
}

