/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.api.ws.definition;

import com.google.common.base.Optional;

import java.net.URL;
import java.util.List;
import java.util.Map;

/**
 * A representation of a WSDL file that can be accessible either locally (e.g.: within the connector's jar) or remote (e.g.: URLs),
 * that will be used for runtime (Mule ESB) or design time (Anypoint Studio) purposes.
 */
public interface ServiceDefinition {

    /**
     * @return the ID that will represent a given WSDL file. E.g.: INCIDENT_MODULE_ID.
     */
    String getId();

    /**
     * @return the fancy name the end user will see in Studio's UI. E.g.: Incident Module.
     */
    String getDisplayName();

    /**
     * @return URLs that targets the real WSDL file.
     */
    URL getWsdlUrl();

    /**
     * @return service's name of the given WSDL file. It might be left to null (which implies {@link com.google.common.base.Optional#absent()}),
     * or it could have a concrete value. If it's left to null, then DevKit will do its best effort to pick it automatically.
     */
    Optional<String> getService();

    /**
     * @return port's name for a given service of the given WSDL file. It might be left to null (which implies {@link com.google.common.base.Optional#absent()}),
     * or it could have a concrete value. If it's left to null, then DevKit will do its best effort to pick it automatically.
     */
    Optional<String> getPort();

    /**
     * @return a set of properties for the current representation of a WSDL file. This is a placeholder to store metadata
     * that might be useful when resolving a service address for the given WSDL file.
     */
    Map<String, Object> getProperties();

    /**
     * @return a List of operation names that should be excluded from the exposed service definition.
     * */
    List<String> getExcludedOperations();
}
