/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.devkit.internal.connection.management;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessInterceptor;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.security.oauth.callback.ProcessCallback;
import org.mule.security.oauth.process.ProcessCallbackProcessInterceptor;
import org.mule.security.oauth.process.RetryProcessInterceptor;

public class ConnectionManagementProcessTemplate<P, Adapter extends ConnectionManagementConnectorAdapter, Key extends ConnectionManagementConnectionKey, Strategy>
        implements ProcessTemplate<P, Adapter> {

    private final ProcessInterceptor<P, Adapter> processInterceptor;

    public ConnectionManagementProcessTemplate(ConnectionManagementConnectionManager<Key, Adapter, Strategy> connManagementBasicConnectionManager, MuleContext muleContext) {
        ProcessInterceptor<P, Adapter> processCallbackProcessInterceptor = new ProcessCallbackProcessInterceptor<P, Adapter>();
        ProcessInterceptor<P, Adapter> managedConnectionProcessInterceptor = new ConnectionManagementProcessInterceptor<P, Adapter, Key, Strategy>(
                processCallbackProcessInterceptor, connManagementBasicConnectionManager, muleContext);
        ProcessInterceptor<P, Adapter> retryProcessInterceptor = new RetryProcessInterceptor<P, Adapter>(managedConnectionProcessInterceptor, muleContext,
                connManagementBasicConnectionManager.getRetryPolicyTemplate());
        processInterceptor = retryProcessInterceptor;
    }

    public P execute(ProcessCallback<P, Adapter> processCallback, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        return processInterceptor.execute(processCallback, null, messageProcessor, event);
    }

    public P execute(ProcessCallback<P, Adapter> processCallback, Filter filter, MuleMessage message) throws Exception {
        return processInterceptor.execute(processCallback, null, filter, message);
    }

}
