/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.metadata;

import org.mule.common.metadata.*;
import org.mule.common.metadata.field.property.MetaDataFieldProperty;
import org.mule.devkit.api.metadata.ComposedMetaDataKey;

import java.util.List;

/**
 * Placeholder of generic methods to reduce generated code
 */
public class MetaDataGeneratorUtils {

    /**
     * This method will create a new {@link MetaData} where:
     * <ol>
     * <li>the inner {@link MetaDataModel} will be the {@code wrappedMetaDataModel} object</li>
     * <li>the properties from {@code userDefinedMetaData} (coded by the connector's developer) will be copied into the newly created {@link MetaData}</li>
     * </ol>
     *
     * @param wrappedMetaDataModel object generated by DevKit, see {@link org.mule.devkit.generation.mule.MessageProcessorGenerator#foldMetaData(GenericType, GeneratedVariable, ProcessorMethod)}
     * @param userDefinedMetaData  metaData object created by the connector's developer to extract and copy its properties
     * @return
     */
    public static MetaData extractPropertiesToMetaData(MetaDataModel wrappedMetaDataModel, MetaData userDefinedMetaData) {
        MetaData generatedMetaData = new DefaultMetaData(wrappedMetaDataModel);

        //looping through all the possible scopes:  FLOW, INBOUND, OUTBOUND, SESSION, RECORD
        for (MetaDataPropertyScope metaDataPropertyScope : MetaDataPropertyScope.values()) {
            MetaDataProperties properties = userDefinedMetaData.getProperties(metaDataPropertyScope);

            //for a given scope, we copy it to the new MetaData object
            for (MetaDataField metaDataField : properties.getFields()) {
                List<MetaDataFieldProperty> userDefinedProperties = metaDataField.getProperties();
                MetaDataFieldProperty[] arrayOfUserDefinedProperties = userDefinedProperties.toArray(new MetaDataFieldProperty[userDefinedProperties.size()]);
                generatedMetaData.addProperty(metaDataPropertyScope, metaDataField.getName(), metaDataField.getMetaDataModel(), arrayOfUserDefinedProperties);
            }
        }
        return generatedMetaData;
    }

    public static List<MetaDataKey> toSimpleKeyWithCategory(List<ComposedMetaDataKey> metadataKeys, String keySeparator, String category) {
        List<MetaDataKey> retrievedKeys = composedToDefaultMetaDataKeys(metadataKeys, keySeparator);
        return fillCategory(retrievedKeys, category);
    }

    public static List<MetaDataKey> fillCategory(List<MetaDataKey> metadataKeys, String categoryClassName) {
        for (MetaDataKey metaDataKey : metadataKeys) {
            ((DefaultMetaDataKey) metaDataKey).setCategory(categoryClassName);
        }
        return metadataKeys;
    }

    private static List<MetaDataKey> composedToDefaultMetaDataKeys(List<ComposedMetaDataKey> metadataKeys, String keySeparator) {
        return InternalComposedMetaDataKeyBuilder.toSimpleKey(metadataKeys, keySeparator);
    }

    public static String getMetaDataException(MetaDataKey key) {
        if ((key != null) && (key.getId() != null)) {
            return ("There was an error retrieving metadata from key: " + (key.getId()
                    + " after acquiring the connection, for more detailed information please read the provided stacktrace"));
        } else {
            return "There was an error retrieving metadata after acquiring the connection, MetaDataKey is null or its id is null, for more detailed information please read the provided stacktrace";
        }
    }

}
