/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.ws.transport;

import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.devkit.api.lifecycle.LifeCycleManager;
import org.mule.devkit.api.ws.transport.HttpBasicWsdlTransport;
import org.mule.devkit.api.ws.transport.HttpRequesterConfigWsdlTransport;
import org.mule.devkit.api.ws.transport.WsdlTransport;
import org.mule.module.http.api.HttpAuthentication;
import org.mule.module.http.api.requester.HttpRequesterConfig;
import org.mule.module.http.api.requester.HttpRequesterConfigBuilder;
import org.mule.module.http.api.requester.authentication.BasicAuthenticationBuilder;

public abstract class WsdlTransportFactoryBuilder {

    public static HttpRequesterConfig build(WsdlTransport wsdlTransport, MuleContext muleContext) throws MuleException, WsdlTransportException {
        HttpRequesterConfig httpRequesterConfig;
        if (wsdlTransport instanceof HttpBasicWsdlTransport) {
            httpRequesterConfig = build((HttpBasicWsdlTransport) wsdlTransport, muleContext);
        } else if (wsdlTransport instanceof HttpRequesterConfigWsdlTransport) {
            httpRequesterConfig = build((HttpRequesterConfigWsdlTransport) wsdlTransport);
        } else {
            throw new WsdlTransportException("The current implementation only supports HttpBasicWsdlTransport and HttpRequesterConfigWsdlTransport as types of transports");
        }
        LifeCycleManager.executeInitialiseAndStart(httpRequesterConfig);
        return httpRequesterConfig;
    }

    private static HttpRequesterConfig build(HttpBasicWsdlTransport httpBasicWsdlTransport, MuleContext muleContext) throws MuleException {
        BasicAuthenticationBuilder basicAuthenticationBuilder = new BasicAuthenticationBuilder(muleContext);
        basicAuthenticationBuilder.setUsername(httpBasicWsdlTransport.getUser());
        basicAuthenticationBuilder.setPassword(httpBasicWsdlTransport.getPass());
        basicAuthenticationBuilder.setPreemptive(httpBasicWsdlTransport.isPreemptive());
        HttpAuthentication httpAuthentication = basicAuthenticationBuilder.build();

        HttpRequesterConfigBuilder httpRequesterConfigBuilder = new HttpRequesterConfigBuilder(muleContext);
        httpRequesterConfigBuilder.setAuthentication(httpAuthentication);
        HttpRequesterConfig httpRequesterConfig = httpRequesterConfigBuilder.build();
        return httpRequesterConfig;
    }

    private static HttpRequesterConfig build(HttpRequesterConfigWsdlTransport httpRequesterConfigWsdlTransport) throws MuleException {
        return httpRequesterConfigWsdlTransport.getConnectorConfig();
    }

}
