/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.api.exception;

import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;

/**
 * Exception thrown when connection is successful but with a limited functionality
 * related to the configuration, that has to be communicated to the connector user
 */
public class ConfigurationWarning extends ConnectionException {

    public ConfigurationWarning(String message) {
        super(ConnectionExceptionCode.UNKNOWN, "", message);
    }
}
