/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.metadata.fixes;

import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.property.StructureIdentifierMetaDataModelProperty;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/**
 * @author MuleSoft, Inc.
 * This class is used to bypass the issue of having a feature released in mule-common 3.7.3+
 * (which is a using the {@link StructureIdentifierMetaDataModelProperty#StructureIdentifierMetaDataModelProperty(MetaDataKey, boolean, boolean)} constructor), but targeting mule-common
 * 3.7.0 while compiling the connector.
 * This will work, as the intended feature is used ONLY in Studio, which ships the lates version of mule-common.
 * For more information see https://www.mulesoft.org/jira/browse/STUDIO-7157
 *
 * This class is intended to be used in 3.7.x DevKit's branch, DO NOT PORT IT to 3.8.x or above, as the needed objects will be available in mule-common
 */
public class STUDIO7157 {

    public static StructureIdentifierMetaDataModelProperty getStructureIdentifierMetaDataModelProperty(MetaDataKey key, boolean derivedStructure, boolean generatedStructure) {
        //We first try to use constructor with 3 parameters StructureIdentifierMetaDataModelProperty#StructureIdentifierMetaDataModelProperty(MetaDataKey, boolean, boolean)
        try {
            return initializeWith3Parameters(key, derivedStructure, generatedStructure);
        }catch (NoSuchMethodException e) {
            //do nothing
        }catch (InstantiationException e) {
            //do nothing
        } catch (IllegalAccessException e) {
            //do nothing
        } catch (InvocationTargetException e) {
            //do nothing
        }

        //If the previous failed, then we will use constructor with 2 parameters StructureIdentifierMetaDataModelProperty#StructureIdentifierMetaDataModelProperty(MetaDataKey, boolean)
        //this is the hack for the hack, as we need not to maintain the way devkit tests metadata in the integration-tests folder ¯\_(ツ)_/¯
        try {
            return initializeWith2Parameters(key, derivedStructure);
        } catch (NoSuchMethodException e) {
            //do nothing
        } catch (InstantiationException e) {
            //do nothing
        } catch (IllegalAccessException e) {
            //do nothing
        } catch (InvocationTargetException e) {
            //do nothing
        }

        throw new RuntimeException("There was an issue while trying to look for the a constructor in mule-common (StructureIdentifierMetaDataModelProperty#StructureIdentifierMetaDataModelProperty(MetaDataKey, boolean, boolean) neither StructureIdentifierMetaDataModelProperty#StructureIdentifierMetaDataModelProperty(MetaDataKey, boolean)). Try upgrading Studio to the latest version.");
    }

    private static StructureIdentifierMetaDataModelProperty initializeWith3Parameters(MetaDataKey key, boolean derivedStructure, boolean generatedStructure) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<StructureIdentifierMetaDataModelProperty> constructor = StructureIdentifierMetaDataModelProperty.class
                .getConstructor(MetaDataKey.class, boolean.class, boolean.class);
        return constructor.newInstance(key, derivedStructure, generatedStructure);
    }

    private static StructureIdentifierMetaDataModelProperty initializeWith2Parameters(MetaDataKey key, boolean derivedStructure)
            throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<StructureIdentifierMetaDataModelProperty> constructor = StructureIdentifierMetaDataModelProperty.class
                .getConstructor(MetaDataKey.class, boolean.class);
        return constructor.newInstance(key, derivedStructure);
    }
}
