/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.ws.common;

import com.google.common.collect.ImmutableMap;
import org.mule.api.MuleContext;
import org.mule.devkit.api.ws.definition.ServiceDefinition;
import org.mule.module.ws.consumer.WSConsumer;

import java.util.concurrent.ExecutionException;

public interface WSResolver {

    ServiceDefinition serviceDefinition(String id);

    EnhancedServiceDefinition enhancedServiceDefinition(String id, WsdlAdapter wsdlAdapter, String operation) throws Exception;

    WSConsumer wsConsumer(EnhancedServiceDefinition enhancedServiceDefinition, MuleContext muleContext) throws ExecutionException;

    void dispose();

    ImmutableMap<String, ServiceDefinition> serviceDefinitions();
}
