/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.api.metadata;

import org.mule.devkit.api.metadata.exception.InvalidKeyException;
import org.mule.util.StringUtils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author Mulesoft, Inc
 */
public class DefaultMetaDataKeyLevel implements MetaDataKeyLevel {

    private Map<String, String> idsForLevel = new LinkedHashMap<String, String>();

    public DefaultMetaDataKeyLevel() {
    }

    @Override
    public Set<Map.Entry<String, String>> getIds() {
        return idsForLevel.entrySet();
    }

    /**
     * Adds the id to the current level. Order of addition is preserved on retrieval.
     *
     * @throws org.mule.devkit.api.metadata.exception.InvalidKeyException
     */
    @Override
    public MetaDataKeyLevel addId(String id, String label) {

        if (StringUtils.isBlank(id) || StringUtils.isBlank(label)) {
            throw new InvalidKeyException("Neither id nor label can be blank");
        }

        if (idsForLevel.containsKey(id)) {
            throw new InvalidKeyException("Duplicated Id in level");
        }

        this.idsForLevel.put(id, label);

        return this;
    }

}
