/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.api.lifecycle;

import org.mule.api.MuleException;
import org.mule.api.lifecycle.*;

public class LifeCycleManager {

    public static void initialise(Object o) throws InitialisationException {
        if (o instanceof Initialisable) {
            ((Initialisable) o).initialise();
        }
    }

    public static void start(Object o) throws MuleException {
        if (o instanceof Startable) {
            ((Startable) o).start();
        }
    }

    public static void stop(Object o) throws MuleException {
        if (o instanceof Stoppable) {
            ((Stoppable) o).stop();
        }
    }

    public static void dispose(Object o) {
        if (o instanceof Disposable) {
            ((Disposable) o).dispose();
        }
    }

    public static void executeInitialiseAndStart(Object o) throws MuleException {
        LifeCycleManager.initialise(o);
        LifeCycleManager.start(o);
    }

    public static void executeStopAndDispose(Object o) throws MuleException {
        LifeCycleManager.stop(o);
        LifeCycleManager.dispose(o);
    }
}
