/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.lic.model;

import com.google.common.base.Optional;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/**
 * @author MuleSoft, Inc
 */
public class ZippedBundle {

    private Map<String, byte[]> bundleFiles;

    public ZippedBundle(InputStream bundle) {
        bundleFiles = unZip(bundle);
    }

    public Optional<byte[]> get(String fileName) {
        return Optional.fromNullable(bundleFiles.get(fileName));
    }

    private Map<String, byte[]> unZip(InputStream fileIS) {

        Map<String, byte[]> entries = new HashMap<String, byte[]>();
        try {
            ZipInputStream zipIS = new ZipInputStream(fileIS);

            ZipEntry ze = zipIS.getNextEntry();
            while (ze != null) {
                entries.put(ze.getName(), readEntry(zipIS));
                ze = zipIS.getNextEntry();
            }
            zipIS.closeEntry();
            zipIS.close();

        } catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException("failed to read input zip ");
        }

        return entries;
    }

    private byte[] readEntry(ZipInputStream zis) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(zis.available());
        int len;
        byte[] buffer = new byte[1024];
        while ((len = zis.read(buffer)) > 0) {
            os.write(buffer, 0, len);
        }
        os.close();
        return os.toByteArray();
    }
}
