/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.lic;

import com.google.common.base.Optional;
import org.mule.devkit.internal.lic.model.Entitlement;
import org.mule.devkit.internal.lic.validator.LicenseValidator;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;

public abstract class AbstractEEDefinitionParser extends AbstractDevkitBasedDefinitionParser {

    public AbstractEEDefinitionParser() {
        LicenseValidator licenseValidator = LicenseValidatorFactory.getValidator(this.moduleName());
        licenseValidator.checkEnterpriseLicense(true);
        if (entitlement().isPresent()) {
            licenseValidator.checkEntitlement(entitlement().get());
        }
    }

    protected abstract String moduleName();

    protected Optional<Entitlement> entitlement() {
        return Optional.absent();
    }

}
