/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.lic.validator;

import org.apache.log4j.Logger;
import org.mule.devkit.internal.lic.model.Entitlement;

/**
 * @author Mulesoft, Inc
 */
public class TestValidator implements LicenseValidator {

    private static final Logger logger = Logger.getLogger(TestValidator.class);

    @Override
    public void checkEnterpriseLicense(boolean allowEvaluation) {
        // No validation during testing mode
        logger.debug("Checking EE license under testing.mode. AllowEvaluation=" + allowEvaluation);
    }

    @Override
    public void checkEntitlement(Entitlement entitlement) {
        // No validation during testing mode
        logger.debug("Checking Entitlement under testing.mode");
        logger.debug("Entitlement info: ");
        logger.debug("  id: " + entitlement.id());
        logger.debug("  provider: " + entitlement.provider() + " -> thirdParty: " + entitlement.isThirdParty());
        logger.debug("  version: " + entitlement.version());
        logger.debug("  description: " + entitlement.description());
        logger.debug("  license name: " + entitlement.licenseName());
    }

}
