/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.ws.model.cache;

public class EnhancedServiceDefinitionKey {

    private String wsdlId;
    private String operation;

    public EnhancedServiceDefinitionKey(String wsdlId, String operation) {
        this.wsdlId = wsdlId;
        this.operation = operation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (!(o instanceof EnhancedServiceDefinitionKey))
            return false;

        EnhancedServiceDefinitionKey that = (EnhancedServiceDefinitionKey) o;

        if (operation != null ? !operation.equals(that.operation) : that.operation != null)
            return false;
        if (wsdlId != null ? !wsdlId.equals(that.wsdlId) : that.wsdlId != null)
            return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = wsdlId != null ? wsdlId.hashCode() : 0;
        result = 31 * result + (operation != null ? operation.hashCode() : 0);
        return result;
    }
}
