/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.api.ws.authentication;

import org.mule.module.ws.security.PasswordType;

public class WsdlUsernameToken implements WsdlSecurityStrategy {

    private String username;
    private String password;
    private PasswordType passwordType;
    private boolean addNonce;
    private boolean addCreated;

    public WsdlUsernameToken(String username, String password, PasswordType passwordType, boolean addNonce, boolean addCreated) {
        this.username = username;
        this.password = password;
        this.passwordType = passwordType;
        this.addNonce = addNonce;
        this.addCreated = addCreated;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PasswordType getPasswordType() {
        return passwordType;
    }

    public void setPasswordType(PasswordType passwordType) {
        this.passwordType = passwordType;
    }

    public boolean isAddNonce() {
        return addNonce;
    }

    public void setAddNonce(boolean addNonce) {
        this.addNonce = addNonce;
    }

    public boolean isAddCreated() {
        return addCreated;
    }

    public void setAddCreated(boolean addCreated) {
        this.addCreated = addCreated;
    }
}
