package org.mule.devkit.internal.source;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.callback.SourceCallback;
import org.mule.security.oauth.processor.AbstractListeningMessageProcessor;

import java.util.Map;

public class ErrorAwareSourceCallback implements SourceCallback {

    private AbstractListeningMessageProcessor delegate;

    public ErrorAwareSourceCallback(AbstractListeningMessageProcessor delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object process() throws Exception {
        try {
            return delegate.process();
        } catch (MessagingException e) {
            return processMessagingException(e).getMessage().getPayload();
        }
    }

    @Override
    public Object process(Object o) throws Exception {
        try {
            return delegate.process(o);
        } catch (MessagingException e) {
            return processMessagingException(e).getMessage().getPayload();
        }
    }

    @Override
    public Object process(Object o, Map<String, Object> map) throws Exception {
        try {
            return delegate.process(o, map);
        } catch (MessagingException e) {
            return processMessagingException(e).getMessage().getPayload();
        }
    }

    @Override
    public MuleEvent processEvent(MuleEvent muleEvent) throws MuleException {
        try {
            return delegate.process(muleEvent);
        } catch (MessagingException e) {
            return processMessagingException(e);
        }
    }

    private MuleEvent processMessagingException(MessagingException e) throws MessagingException {
        MuleEvent muleEvent = delegate.getFlowConstruct().getExceptionListener().handleException(e, e.getEvent());
        if(muleEvent.getMessage().getExceptionPayload() == null) {
            return muleEvent;
        } else {
            throw e;
        }
    }
}
