/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.model.studio;

import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mule.devkit.model.code.CodeWriter;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EditorModel {

    private StudioModel.ConfigRefBuilder<JAXBElement<? extends AbstractElementType>> configRefBuilder;
    private StudioModel.BuilderWithArgs<Boolean, JAXBElement<PatternType>> patternTypeOperationsBuilder;
    private boolean isOAuth;
    private String outputFileName;
    private NamespaceType namespaceType;
    private List<StudioModel.BuilderWithArgs<Boolean, List<JAXBElement<? extends AbstractElementType>>>> listOfOperations;
    private List<StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>>> listOfComplexTypesBuilders;
    private CodeWriter codeWriter;

    public EditorModel(CodeWriter codeWriter) {
        this.codeWriter = codeWriter;
        namespaceType = new NamespaceType();
        this.listOfOperations = new ArrayList<StudioModel.BuilderWithArgs<Boolean, List<JAXBElement<? extends AbstractElementType>>>>();
        this.listOfComplexTypesBuilders = new ArrayList<StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>>>();
        isOAuth = false;
    }

    public StudioModel.ConfigRefBuilder<JAXBElement<? extends AbstractElementType>> getConfigRefBuilder() {
        return configRefBuilder;
    }

    public void setConfigRefBuilder(StudioModel.ConfigRefBuilder<JAXBElement<? extends AbstractElementType>> configRefBuilder) {
        this.configRefBuilder = configRefBuilder;
    }

    public void setPatternTypeOperationsBuilder(StudioModel.BuilderWithArgs<Boolean, JAXBElement<PatternType>> patternTypeOperationsBuilder) {
        this.patternTypeOperationsBuilder = patternTypeOperationsBuilder;
    }

    public NamespaceType getNamespaceType() {
        return namespaceType;
    }

    public void setOAuth(boolean OAuth) {
        isOAuth = OAuth;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void addProcessorOperations(StudioModel.BuilderWithArgs<Boolean, List<JAXBElement<? extends AbstractElementType>>> operations) {
        this.listOfOperations.add(operations);
    }

    public void addNestedElements(StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>> nestedElements) {
        this.listOfComplexTypesBuilders.add(nestedElements);
    }

    public void serializeXml() throws JAXBException, IOException {


        if (outputFileName == null) {
            throw new IllegalStateException("Error: Can't generate XML. outputFileName has not been specified.");
        }

        namespaceType.getConnectorOrEndpointOrGlobal().add(configRefBuilder.build());
        namespaceType.getConnectorOrEndpointOrGlobal().add(patternTypeOperationsBuilder.build(isOAuth));

        addOnlyOnce(mapArgsBuilderToBuilder(isOAuth, listOfOperations));
        addOnlyOnce(listOfComplexTypesBuilders);

        JAXBContext jaxbContext = JAXBContext.newInstance(NamespaceType.class);
        Marshaller marshaller = jaxbContext.createMarshaller();
        NamespaceFilter outFilter = new NamespaceFilter("mule", "http://www.mulesoft.org/schema/mule/core", true);
        OutputFormat format = new OutputFormat();
        format.setIndent(true);
        format.setNewlines(true);
        OutputStream schemaStream = this.codeWriter.openBinary(null, outputFileName);
        XMLWriter writer = new XMLWriter(schemaStream, format);
        outFilter.setContentHandler(writer);
        marshaller.marshal(namespaceType, outFilter);
    }

    private <U, T> List<StudioModel.Builder<T>> mapArgsBuilderToBuilder(U arg,  List<StudioModel.BuilderWithArgs<U, T>> builderWithArgsList) {
        List<StudioModel.Builder<T>> builders = new ArrayList<StudioModel.Builder<T>>();

        for( StudioModel.BuilderWithArgs<U, T> builderWithArgs : builderWithArgsList) {
            builders.add(new BuilderWithNoArgsAdapter<U, T>(arg, builderWithArgs));
        }

        return builders;
    }

    private static class BuilderWithNoArgsAdapter<U, T> implements StudioModel.Builder<T> {

        private StudioModel.BuilderWithArgs<U, T> builderWithArgs;
        private U arg;

        public BuilderWithNoArgsAdapter(U arg, StudioModel.BuilderWithArgs<U, T> builderWithArgs) {
            this.builderWithArgs = builderWithArgs;
            this.arg = arg;
        }

        @Override
        public T build() {
            return builderWithArgs.build(arg);
        }
    }

    private void addOnlyOnce(List<StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>>> builders) {
        Set<String> elementsAlreadyAdded = new HashSet<String>();

        for (StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>> elements : builders) {

            List<JAXBElement<? extends AbstractElementType>> elementList = elements.build();

            Collections.sort(elementList, new Comparator<JAXBElement<? extends AbstractElementType>>() {
                @Override
                public int compare(JAXBElement<? extends AbstractElementType> a,
                                   JAXBElement<? extends AbstractElementType> b) {
                    return a.getValue().getLocalId().compareTo(b.getValue().getLocalId());
                }
            });

            for (JAXBElement<? extends AbstractElementType> element : elementList) {

                String localId = element.getValue().getLocalId();
                if (!elementsAlreadyAdded.contains(localId)) {
                    namespaceType.getConnectorOrEndpointOrGlobal().add(element);
                    elementsAlreadyAdded.add(localId);
                }
            }
        }
    }
}
