/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.model.studio;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

/**
 * <type-chooser associatedConfig="config-ref"
 * required="true" description="Type of object to create." caption="sObject Type" name="type"></type-chooser>
 */

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TypeChooserType")
public class TypeChooserType extends AttributeType {

    @XmlAttribute(name = "associatedConfig")
    protected String associatedConfig;
    @XmlAttribute(name = "affects")
    protected String affects;

    public String getAssociatedConfig() {
        return associatedConfig;
    }

    public void setAssociatedConfig(String associatedConfig) {
        this.associatedConfig = associatedConfig;
    }

    public String getAffects() {
        return affects;
    }

    public void setAffects(String affects) {
        this.affects = affects;
    }
}
