/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.model.studio;

import org.mule.devkit.model.code.CodeWriter;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StudioModel {

    private CodeWriter codeWriter;
    private Map<String, EditorModel> editorModels;

    public StudioModel(CodeWriter codeWriter) {
        this.codeWriter = codeWriter;
        this.editorModels = new HashMap<String, EditorModel>();
    }

    public void build() throws IOException {
        try {
            for (EditorModel studioXMLSerializer : editorModels.values()) {
                studioXMLSerializer.serializeXml();
            }
        } catch (JAXBException e) {
            throw new IOException(e);
        } catch (UnsupportedEncodingException e) {
            throw new IOException(e);
        }
    }

    public void addNamespaceType(String moduleName, String outputFileName) {
        getOrCreateEditorModel(moduleName).setOutputFileName(outputFileName);
    }

    private EditorModel getOrCreateEditorModel(String moduleName) {
        EditorModel editorModel = editorModels.get(moduleName);

        if (editorModel == null) {
            editorModel = new EditorModel(codeWriter);
            editorModels.put(moduleName, editorModel);
        }
        return editorModel;
    }

    public NamespaceType getOrCreateNamespace(String moduleName) {
        return getOrCreateEditorModel(moduleName).getNamespaceType();
    }

    public void addPatternTypeOperation(String moduleName, StudioModel.BuilderWithArgs<Boolean, JAXBElement<PatternType>> patternTypeOperationsChooser) {
        this.getOrCreateEditorModel(moduleName).setPatternTypeOperationsBuilder(patternTypeOperationsChooser);
    }

    public void addIsOAuth(String moduleName, boolean isOAuth) {
        this.getOrCreateEditorModel(moduleName).setOAuth(isOAuth);
    }

    public static interface ConfigRefBuilder<T> extends Builder<T> {
        void addRequiredType(String configElementName);
    }

    public static interface Builder<T> {
        T build();
    }

    public static interface BuilderWithArgs<U, T> {
        T build(U param);
    }

    public void addConfigBuilderRef(String moduleName, ConfigRefBuilder<JAXBElement<? extends AbstractElementType>> builder) {
        this.getOrCreateEditorModel(moduleName).setConfigRefBuilder(builder);
    }

    public ConfigRefBuilder<JAXBElement<? extends AbstractElementType>> getConfigBuilderRef(String moduleName) {
        return this.getOrCreateEditorModel(moduleName).getConfigRefBuilder();
    }

    public void addProcessorMethods(String moduleName, StudioModel.BuilderWithArgs<Boolean, List<JAXBElement<? extends AbstractElementType>>> processProcessorMethodsChooser) {
        this.getOrCreateEditorModel(moduleName).addProcessorOperations(processProcessorMethodsChooser);
    }

    public void addNestedElements(String moduleName, Builder<List<JAXBElement<? extends AbstractElementType>>> nestedElementsBuilder) {
        this.getOrCreateEditorModel(moduleName).addNestedElements(nestedElementsBuilder);
    }

}