package org.mule.devkit.model.studio.libraries;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "jar", namespace = "http://www.mulesoft.org/schema/mule/tooling.attributes")
public class JarElement extends ExternalLib {

    @XmlAttribute( name = "fileName", required = false)
    protected String fileName;

    @XmlAttribute( name = "targetFolder", required = false)
    protected String targetFolder;

    @XmlAttribute( name = "targetRuntimeFolder", required = false)
    protected String targetRuntimeFolder;

    @XmlAttribute( name = "className", required = false)
    protected String className;

    @XmlAttribute( name = "externalPluginDependency")
    protected boolean externalPluginDependency = true;

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getTargetFolder() {
        return targetFolder;
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public String getTargetRuntimeFolder() {
        return targetRuntimeFolder;
    }

    public void setTargetRuntimeFolder(String targetRuntimeFolder) {
        this.targetRuntimeFolder = targetRuntimeFolder;
    }

    public boolean isExternalPluginDependency() { return externalPluginDependency; }

    public void setExternalPluginDependency(boolean externalPluginDependency) { this.externalPluginDependency = externalPluginDependency; }

    public String getClassName() { return className; }

    public void setClassName(String className) { this.className = className; }

}
