/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.studio;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * @author MuleSoft, Inc.
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ContainerType")
public class ContainerType
        extends PatternType
{
    @XmlAttribute(name = "pathExpression", required = true)
    protected String pathExpression;

    @XmlAttribute(name = "acceptedByElements", required = true)
    protected String acceptedByElements;

    @XmlAttribute(name = "titleColor")
    protected String titleColor;

    @XmlElement(name = "graphical-container", required = true)
    protected GraphicalContainerType graphicalContainer;

    public String getPathExpression()
    {
        return pathExpression;
    }

    public String getAcceptedByElements()
    {
        return acceptedByElements;
    }

    public void setPathExpression(String pathExpression)
    {
        this.pathExpression = pathExpression;
    }

    public void setAcceptedByElements(String acceptedByElements)
    {
        this.acceptedByElements = acceptedByElements;
    }

    public String getTitleColor()
    {
        return titleColor;
    }

    public void setTitleColor(String titleColor)
    {
        this.titleColor = titleColor;
    }

    public GraphicalContainerType getGraphicalContainer()
    {
        if (graphicalContainer == null){
            graphicalContainer = new GraphicalContainerType();
        }
        return graphicalContainer;
    }

    public void setGraphicalContainer(GraphicalContainerType graphicalContainer)
    {
        this.graphicalContainer = graphicalContainer;
    }
}
