/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.studio;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

/**
 * @author MuleSoft, Inc.
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "keyword")
public class Keyword
{
    @XmlAttribute(name = "value", required = true)
    protected String value;
    @XmlAttribute(name = "weight", required = true)
    protected Integer weight;

    public Keyword()
    {
    }

    public Keyword(String value, Integer weight)
    {
        this.value = value;
        this.weight = weight;
    }

    public String getValue()
    {
        return value;
    }

    public void setValue(String value)
    {
        this.value = value;
    }

    public Integer getWeight()
    {
        return weight;
    }

    public void setWeight(Integer weight)
    {
        this.weight = weight;
    }
}
