/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.devkit.model.studio;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class NamespaceFilter extends XMLFilterImpl {

    private String usedNamespaceUri;
    private String prefix;
    private boolean addNamespace;
    private boolean addedNamespace;

    public NamespaceFilter(String prefix, String namespaceUri, boolean addNamespace) {

        if (addNamespace) {
            this.prefix = prefix;
            this.usedNamespaceUri = namespaceUri;
        } else {
            this.prefix = "";
            this.usedNamespaceUri = "";
        }
        this.addNamespace = addNamespace;
    }


    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        if (addNamespace) {
            startControlledPrefixMapping();
        }
    }


    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(usedNamespaceUri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(usedNamespaceUri, localName, qName);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        if (addNamespace) {
            startControlledPrefixMapping();
        } else {
            //Remove the namespace, i.e. don't call startPrefixMapping for parent!
        }
    }

    private void startControlledPrefixMapping() throws SAXException {
        if (addNamespace && !addedNamespace) {
            //We should add namespace since it is set and has not yet been done.
            super.startPrefixMapping(prefix, usedNamespaceUri);
            //Make sure we dont do it twice
            addedNamespace = true;
        }
    }
}