/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.studio.metadata;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

/**
 * This type is used to represent @MetadataKeyParams for multi-level MetaDataKeys
 * */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "multi-type-chooser")
public class MultiTypeChooserType extends TypeChooserType {

    @XmlAttribute(name = "captions")
    protected String captions;

    @XmlAttribute(name = "keySeparator")
    protected String keySeparator;

    public String getCaptions() {
        return captions;
    }

    public void setCaptions(String captions) {
        this.captions = captions;
    }

    public String getKeySeparator() { return keySeparator; }

    public void setKeySeparator(String keySeparator) { this.keySeparator = keySeparator; }
}
