/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.studio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.studio.Module;
import org.mule.devkit.model.studio.NamespaceFilter;
import org.xml.sax.ContentHandler;

public class StudioModel {
    private static final String XML_FILE_NAME = "META-INF/%s-studio.xml";
    private CodeWriter codeWriter;
    private String moduleName;
    private Module module;

    public StudioModel(CodeWriter codeWriter) {
        this.codeWriter = codeWriter;
    }

    public void build() throws IOException {
        try {
            if (this.module != null) {
                this.serializeXml();
            }
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e);
        }
    }

    private void serializeXml() throws JAXBException, IOException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Module.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        NamespaceFilter outFilter = new NamespaceFilter("mule", "http://www.mulesoft.org/schema/mule/core", true);
        OutputFormat format = new OutputFormat();
        format.setIndent(true);
        format.setNewlines(true);
        OutputStream schemaStream = this.codeWriter.openBinary(null, String.format(XML_FILE_NAME, this.moduleName));
        XMLWriter writer = new XMLWriter(schemaStream, format);
        outFilter.setContentHandler((ContentHandler)writer);
        marshaller.marshal((Object)this.module, (ContentHandler)outFilter);
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setModule(Module module) {
        this.module = module;
    }
}

