/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.studio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.studio.NamespaceFilter;
import org.mule.devkit.model.studio.NamespaceType;
import org.xml.sax.ContentHandler;

public class StudioModel {
    private CodeWriter codeWriter;
    private NamespaceType namespaceType;
    private String outputFileName;

    public StudioModel(CodeWriter codeWriter) {
        this.codeWriter = codeWriter;
    }

    public void build() throws IOException {
        try {
            if (this.namespaceType != null) {
                this.serializeXml();
            }
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e);
        }
    }

    private void serializeXml() throws JAXBException, IOException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{NamespaceType.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        NamespaceFilter outFilter = new NamespaceFilter("mule", "http://www.mulesoft.org/schema/mule/core", true);
        OutputFormat format = new OutputFormat();
        format.setIndent(true);
        format.setNewlines(true);
        OutputStream schemaStream = this.codeWriter.openBinary(null, this.outputFileName);
        XMLWriter writer = new XMLWriter(schemaStream, format);
        outFilter.setContentHandler((ContentHandler)writer);
        marshaller.marshal((Object)this.namespaceType, (ContentHandler)outFilter);
    }

    public void setNamespaceType(NamespaceType namespaceType) {
        this.namespaceType = namespaceType;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }
}

