package org.mule.devkit.wsdl;

import java.util.ArrayList;
import java.util.List;

public class ObjectType implements Identifiable{
	
	private String name;
	private String type;
	private String base;
	private String ref;
	
	private String minOccurs = "1";
	private String maxOccurs = "1";
	private String nillable = "false";
	private String isAbstract = "false";
	
	private List<ObjectType> innerObjectType;

	public String getMinOccurs() {
		return minOccurs;
	}

	public void setMinOccurs(String minOccurs) {
		this.minOccurs = minOccurs;
	}

	public String getMaxOccurs() {
		return maxOccurs;
	}

	public void setMaxOccurs(String maxOccurs) {
		this.maxOccurs = maxOccurs;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	@Override
	public String toString(){
		return name + ":" + type;
	}

	public List<ObjectType> getInnerObjectType() {
		if(innerObjectType==null)
			innerObjectType = new ArrayList<ObjectType>();
		return innerObjectType;
	}

	public void setInnerObjectType(List<ObjectType> innerObjectType) {
		this.innerObjectType = innerObjectType;
	}

	public String getNillable() {
		return nillable;
	}

	public void setNillable(String nillable) {
		this.nillable = nillable;
	}
	
	public boolean isAnArray(){
		return !maxOccurs.equals("1");
	}

	public String getId() {
		return getName();
	}

	public String getIsAbstract() {
		return isAbstract;
	}

	public void setIsAbstract(String isAbstract) {
		this.isAbstract = isAbstract;
	}

	public String getBase() {
		return base;
	}

	public void setBase(String base) {
		this.base = base;
	}

	public String getRef() {
		return ref;
	}

	public void setRef(String ref) {
		this.ref = ref;
	}
}
