package org.mule.devkit.wsdl;

import java.util.ArrayList;
import java.util.List;

public class Definition implements Identifiable{
	private String fileName;
	private List<Schema>	schemas;
	private List<PortType> portTypes;
	private List<Binding> bindings;
	private List<Message> messages;
	private List<Service> services;
	
	public List<Binding> getBindings() {
		if(bindings==null)
			bindings = new ArrayList<Binding>();
		return bindings;
	}

	public void setBindings(List<Binding> bindings) {
		this.bindings = bindings;
	}
	
	public void addBinding(Binding binding) {
		this.getBindings().add(binding);
	}
	public List<Service> getServices() {
		if(services==null)
			services = new ArrayList<Service>();
		return services;
	}

	public void setServices(List<Service> services) {
		this.services = services;
	}

	public List<PortType> getPortTypes() {
		if(portTypes==null)
			portTypes = new ArrayList<PortType>();
		return portTypes;
	}

	public void setPortTypes(List<PortType> portTypes) {
		this.portTypes = portTypes;
	}
	
	public void addPortType(PortType portType){
		this.getPortTypes().add(portType);
	}

	public Address getAddressByPortType(String portTypeName){
		String binding = null;
		for(Binding bd : this.getBindings()){
			if(bd.getType().endsWith(portTypeName)){
				binding = bd.getName();
			}
		}
		if(binding==null)
			return null;
		Address address = null;
		for(Service service : this.getServices()){
			for(Port port : service.getPorts()){
				if(port.getBinding().endsWith(binding)){
					address = port.getAddress();
				}
			}
		}
		return address;
		
	}

	public List<ObjectType> getParametersFromMessage(String name){
		Operation operation = null;
		for(PortType pt : this.getPortTypes()){
			for(Operation op : pt.getOperations()){
				if(op.getName().equals(name)){
					operation = op;
				}
			}
		}
		String messageName = operation.getInput().getMessage();
		String localName = messageName.contains(":") ? messageName.substring(messageName.indexOf(":")+1): messageName;
		Message message = null;
		for(Message m : this.getMessages()){
			if(m.getName().equals(localName)){
				message = m;
				break;
			}
		}
		List<Part> list = message.getPart();
		List<ObjectType> types = new ArrayList<ObjectType>();
		for(Part p : list){
			String partName = p.getElement();
			String local= partName.contains(":") ? partName.substring(partName.indexOf(":")+1): partName;
			for(Schema sc : this.getSchemas()){
				for(ObjectType type:sc.getTypes()){
					if(type.getName().equals(local))
						types.add(type);
				}
			}
		}
		
		return types;
	}
	
	public Operation getOperationByName(String name){
		for(PortType pt : this.getPortTypes()){
			for(Operation op : pt.getOperations()){
				if(op.getName().equals(name)){
					return op;
				}
			}
		}
		return null;
	}
	
	public List<ObjectType> getOutputFromMessage(String name){
		Operation operation = null;
		for(PortType pt : this.getPortTypes()){
			for(Operation op : pt.getOperations()){
				if(op.getName().equals(name)){
					operation = op;
				}
			}
		}
		String messageName = operation.getOutput().getMessage();
		String localName = messageName.contains(":") ? messageName.substring(messageName.indexOf(":")+1): messageName;
		Message message = null;
		for(Message m : this.getMessages()){
			if(m.getName().equals(localName)){
				message = m;
				break;
			}
		}
		List<Part> list = message.getPart();
		List<ObjectType> types = new ArrayList<ObjectType>();
		for(Part p : list){
			String partName = p.getElement();
			String local= partName.contains(":") ? partName.substring(partName.indexOf(":")+1): partName;
			for(Schema sc : this.getSchemas()){
				for(ObjectType type:sc.getTypes()){
					if(type.getName().equals(local))
						types.add(type);
				}
			}
		}
		
		return types;
	}
	public List<Schema> getSchemas() {
		if(schemas==null)
			schemas = new ArrayList<Schema>();
		return schemas;
	}

	public void setSchemas(List<Schema> schemas) {
		this.schemas = schemas;
	}

	public List<Message> getMessages() {
		if(messages==null)
			messages = new ArrayList<Message>();
		return messages;
	}

	public void setMessages(List<Message> messages) {
		this.messages = messages;
	}
	
	public void addMessage(Message message){
		this.getMessages().add(message);
	}
	
	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public String getId() {
		return getFileName();
	}
}
