/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.wsdl.parser;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.beanutils.PropertyUtils;
import org.mule.devkit.wsdl.Address;
import org.mule.devkit.wsdl.Binding;
import org.mule.devkit.wsdl.Definition;
import org.mule.devkit.wsdl.Fault;
import org.mule.devkit.wsdl.Header;
import org.mule.devkit.wsdl.Input;
import org.mule.devkit.wsdl.Message;
import org.mule.devkit.wsdl.ObjectType;
import org.mule.devkit.wsdl.Operation;
import org.mule.devkit.wsdl.Output;
import org.mule.devkit.wsdl.Part;
import org.mule.devkit.wsdl.Port;
import org.mule.devkit.wsdl.PortType;
import org.mule.devkit.wsdl.Schema;
import org.mule.devkit.wsdl.Service;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLReader {
    private static final Logger logger = Logger.getLogger(WSDLReader.class.getName());
    private Element root;
    private Definition def;
    private static final String COMPLEX_TYPE = "complexType";
    private static final String SIMPLE_TYPE = "simpleType";
    private static final String ELEMENT = "element";
    private static final String SEQUENCE = "sequence";
    private static final String COMPLEX_CONTENT = "complexContent";
    private static final String EXTENSION = "extension";
    private static final String RESTRICTION = "restriction";
    private Stack<String> paths = new Stack();

    public Definition getFromWsdl(String path) throws ParserConfigurationException, SAXException, IOException, DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, WSDLException {
        WSDLFactory factory = WSDLFactory.newInstance();
        ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
        javax.wsdl.xml.WSDLReader wsdlReader = factory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        wsdlReader.setExtensionRegistry(registry);
        javax.wsdl.Definition definition = wsdlReader.readWSDL(path);
        if (definition == null) {
            throw new RuntimeException("Could not load file with path:" + path);
        }
        this.def = new Definition();
        this.def.setFileName(path);
        this.populateDefinition(definition);
        return this.def;
    }

    private void populateDefinition(javax.wsdl.Definition definition) {
        this.loadServices(definition);
        this.loadPortTypes(definition);
        this.loadTypes(definition);
        this.loadBindings(definition);
        this.loadMessages(definition);
    }

    private void loadTypes(javax.wsdl.Definition definition) {
        Types types = definition.getTypes();
        if (types != null) {
            for (Object element : types.getExtensibilityElements()) {
                javax.wsdl.extensions.schema.Schema schemaItem = (javax.wsdl.extensions.schema.Schema)element;
                try {
                    Schema schema = new Schema();
                    this.processSchema(schema, schemaItem.getElement());
                    this.def.getSchemas().add(schema);
                }
                catch (IllegalAccessException e) {
                    logger.warning(e.getMessage());
                }
                catch (InvocationTargetException e) {
                    logger.warning(e.getMessage());
                }
                catch (NoSuchMethodException e) {
                    logger.warning(e.getMessage());
                }
            }
        }
    }

    private void loadMessages(javax.wsdl.Definition definition) {
        Map messages = definition.getMessages();
        if (messages != null) {
            for (Object messageDef : messages.values()) {
                javax.wsdl.Message messageItem = (javax.wsdl.Message)messageDef;
                Message message = new Message();
                message.setName(messageItem.getQName().getLocalPart());
                this.def.addMessage(message);
                this.addMessageParts(messageItem, message);
            }
        }
    }

    private void addMessageParts(javax.wsdl.Message messageItem, Message message) {
        Map parts = messageItem.getParts();
        ArrayList<Part> messageParts = new ArrayList<Part>();
        for (Object partDef : parts.values()) {
            javax.wsdl.Part partItem = (javax.wsdl.Part)partDef;
            Part part = new Part();
            part.setName(partItem.getName());
            if (partItem.getTypeName() != null) {
                part.setType(partItem.getTypeName().getLocalPart());
            } else {
                part.setType("");
            }
            if (partItem.getElementName() != null) {
                part.setElement(partItem.getElementName().getLocalPart());
            } else {
                part.setElement("");
            }
            messageParts.add(part);
        }
        message.setTypes(messageParts);
    }

    private void loadBindings(javax.wsdl.Definition definition) {
        Map bindings = definition.getAllBindings();
        if (bindings != null) {
            for (Object bindingDef : bindings.values()) {
                javax.wsdl.Binding bindingItem = (javax.wsdl.Binding)bindingDef;
                Binding binding = new Binding();
                this.def.getBindings().add(binding);
                binding.setName(bindingItem.getQName().getLocalPart());
                binding.setType(bindingItem.getPortType().getQName().getLocalPart());
                this.addBindingOperations(bindingItem, binding);
            }
        }
    }

    private void addBindingOperations(javax.wsdl.Binding bindingItem, Binding binding) {
        for (Object operationDef : bindingItem.getBindingOperations()) {
            BindingOperation operationItem = (BindingOperation)operationDef;
            Operation op = new Operation();
            op.setName(operationItem.getName());
            this.addDocumentation(operationItem, op);
            this.addInput(operationItem, op);
            this.addOutput(operationItem, op);
            this.addFaults(operationItem, op);
            binding.addOperation(op);
        }
    }

    private void addDocumentation(BindingOperation operationItem, Operation op) {
        if (operationItem.getDocumentationElement() != null) {
            op.setDocumentation(operationItem.getDocumentationElement().getTextContent());
        }
    }

    private void addInput(BindingOperation operationItem, Operation op) {
        if (operationItem.getBindingInput() != null) {
            Input input = new Input();
            input.setName(operationItem.getBindingInput().getName());
            this.addHeaders(operationItem, input);
            op.setInput(input);
        }
    }

    private void addHeaders(BindingOperation operationItem, Input input) {
        for (Object extElement : operationItem.getBindingInput().getExtensibilityElements()) {
            if (!(extElement instanceof SOAPHeader)) continue;
            Header header = new Header();
            header.setMessage(((SOAPHeader)extElement).getMessage().getLocalPart());
            header.setUse(((SOAPHeader)extElement).getUse());
            header.setPart(((SOAPHeader)extElement).getPart());
            input.addHeader(header);
        }
    }

    private void addOutput(BindingOperation operationItem, Operation op) {
        if (operationItem.getBindingOutput() != null) {
            Output output = new Output();
            output.setName(operationItem.getBindingOutput().getName());
            op.setOutput(output);
        }
    }

    private void addFaults(BindingOperation operationItem, Operation op) {
        Map faults = operationItem.getBindingFaults();
        if (faults != null) {
            for (Object faultDef : faults.values()) {
                BindingFault faultItem = (BindingFault)faultDef;
                Fault fault = new Fault();
                fault.setName(faultItem.getName());
                op.addFault(fault);
            }
        }
    }

    private void loadServices(javax.wsdl.Definition definition) {
        Map services = definition.getAllServices();
        if (services != null) {
            for (Object serviceDef : services.values()) {
                javax.wsdl.Service serviceItem = (javax.wsdl.Service)serviceDef;
                Service service = new Service();
                this.def.getServices().add(service);
                service.setName(serviceItem.getQName().getLocalPart());
                this.addDocumentation(serviceItem, service);
                this.addPorts(serviceItem, service);
            }
        }
    }

    private void addPorts(javax.wsdl.Service serviceItem, Service service) {
        Map portsMap = serviceItem.getPorts();
        if (portsMap != null) {
            for (Object portDef : portsMap.values()) {
                javax.wsdl.Port portItem = (javax.wsdl.Port)portDef;
                Port port = new Port();
                service.addPort(port);
                port.setName(portItem.getName());
                port.setBinding(portItem.getBinding().getQName().getLocalPart());
                this.addAddress(portItem, port);
            }
        }
    }

    private void addAddress(javax.wsdl.Port portItem, Port port) {
        List extElements = portItem.getExtensibilityElements();
        for (Object element : extElements) {
            Address addr;
            SOAPAddress address;
            if (element instanceof SOAPAddress) {
                address = (SOAPAddress)element;
                addr = new Address();
                addr.setLocation(address.getLocationURI());
                port.setAddress(addr);
                continue;
            }
            if (element instanceof SOAP12Address) {
                address = (SOAP12Address)element;
                addr = new Address();
                addr.setLocation(address.getLocationURI());
                port.setAddress(addr);
                continue;
            }
            logger.log(Level.WARNING, "Unsupported type: " + element.getClass());
        }
    }

    private void addDocumentation(javax.wsdl.Service serviceItem, Service service) {
        if (serviceItem.getDocumentationElement() != null) {
            service.setDocumentation(serviceItem.getDocumentationElement().getTextContent());
        }
    }

    private void loadPortTypes(javax.wsdl.Definition definition) {
        Map portTypes = definition.getAllPortTypes();
        if (portTypes != null) {
            for (Object portTypeDef : portTypes.values()) {
                javax.wsdl.PortType portType = (javax.wsdl.PortType)portTypeDef;
                PortType pType = new PortType();
                this.def.getPortTypes().add(pType);
                pType.setName(portType.getQName().getLocalPart());
                this.addOperations(portType, pType);
            }
        }
    }

    private void addOperations(javax.wsdl.PortType portType, PortType pType) {
        for (Object operationDef : portType.getOperations()) {
            javax.wsdl.Operation op = (javax.wsdl.Operation)operationDef;
            Operation operation = new Operation();
            pType.addOperation(operation);
            operation.setName(op.getName());
            this.addDocumentation(op, operation);
            this.addInput(op, operation);
            this.addOutput(op, operation);
            this.addFaults(op, operation);
        }
    }

    private void addFaults(javax.wsdl.Operation op, Operation operation) {
        Map faults = op.getFaults();
        if (faults != null) {
            for (Object faultDef : faults.values()) {
                javax.wsdl.Fault faultItem = (javax.wsdl.Fault)faultDef;
                Fault fault = new Fault();
                fault.setName(faultItem.getName());
                fault.setMessage(faultItem.getMessage().getQName().getLocalPart());
                operation.addFault(fault);
            }
        }
    }

    private void addOutput(javax.wsdl.Operation op, Operation operation) {
        if (op.getOutput() != null) {
            Output output = new Output();
            output.setName(op.getOutput().getName());
            output.setMessage(op.getOutput().getMessage().getQName().getLocalPart());
            operation.setOutput(output);
        }
    }

    private void addInput(javax.wsdl.Operation op, Operation operation) {
        if (op.getInput() != null) {
            Input input = new Input();
            input.setName(op.getInput().getName());
            input.setMessage(op.getInput().getMessage().getQName().getLocalPart());
            operation.setInput(input);
        }
    }

    private void addDocumentation(javax.wsdl.Operation op, Operation operation) {
        if (op.getDocumentationElement() != null) {
            operation.setDocumentation(op.getDocumentationElement().getTextContent());
        }
    }

    private void processSchema(Schema schema, Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        NodeList nodes = node.getChildNodes();
        this.populateAttribute(schema, node, "targetNamespace");
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3 || !ELEMENT.equals(childNode.getLocalName()) && !SIMPLE_TYPE.equals(childNode.getLocalName()) && !COMPLEX_TYPE.equals(childNode.getLocalName())) continue;
            ObjectType obj = new ObjectType();
            this.populateAttribute(obj, childNode, "name");
            this.populateAttribute(obj, childNode, "type");
            Object value = this.getAttribute(childNode, "abstract");
            if (value != null) {
                obj.setIsAbstract((String)value);
            }
            if (childNode.hasChildNodes()) {
                if (ELEMENT.equals(childNode.getLocalName())) {
                    this.processElement(obj, childNode);
                } else if (COMPLEX_TYPE.equals(childNode.getLocalName())) {
                    this.processComplexType(obj, childNode);
                } else if (SIMPLE_TYPE.equals(childNode.getLocalName())) {
                    this.processSimpleType(obj, childNode);
                }
            }
            schema.getTypes().add(obj);
        }
    }

    private void processSimpleType(ObjectType objectType, Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        NodeList nodes = node.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3 || !COMPLEX_TYPE.equals(childNode.getLocalName())) continue;
            this.processComplexType(objectType, childNode);
        }
    }

    private void processElement(ObjectType objectType, Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        NodeList nodes = node.getChildNodes();
        this.populateAttributes(objectType, node);
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3 || !RESTRICTION.equals(childNode.getLocalName())) continue;
            this.processComplexType(objectType, childNode);
        }
    }

    private void processComplexType(ObjectType objectType, Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        NodeList nodes = node.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
            Node seqElement;
            int element;
            NodeList seqElements;
            Node childNode = nodes.item(nodeIndex);
            if (childNode.getNodeType() == 3) continue;
            if (COMPLEX_CONTENT.equals(childNode.getLocalName())) {
                seqElements = childNode.getChildNodes();
                for (element = 0; element < seqElements.getLength(); ++element) {
                    seqElement = seqElements.item(element);
                    if (seqElement.getNodeType() == 3) continue;
                    if (EXTENSION.equals(seqElement.getLocalName())) {
                        this.populateAttributes(objectType, seqElement);
                        this.processComplexType(objectType, seqElement);
                        continue;
                    }
                    if (!RESTRICTION.equals(seqElement.getLocalName())) continue;
                    this.populateAttributes(objectType, seqElement);
                    this.processRestriction(objectType, seqElement);
                }
                continue;
            }
            if (!SEQUENCE.equals(childNode.getLocalName())) continue;
            seqElements = childNode.getChildNodes();
            for (element = 0; element < seqElements.getLength(); ++element) {
                seqElement = seqElements.item(element);
                if (seqElement.getNodeType() == 3) continue;
                ObjectType innerObjectType = new ObjectType();
                if (ELEMENT.equals(seqElement.getLocalName())) {
                    this.populateAttributes(innerObjectType, seqElement);
                }
                objectType.getInnerObjectType().add(innerObjectType);
            }
        }
    }

    private void processRestriction(ObjectType objectType, Node seqElement) {
    }

    private void populateAttributes(Object entity, Node node) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (int attributeIndex = 0; attributeIndex < node.getAttributes().getLength(); ++attributeIndex) {
            try {
                PropertyUtils.setProperty((Object)entity, (String)node.getAttributes().item(attributeIndex).getNodeName(), (Object)node.getAttributes().item(attributeIndex).getNodeValue());
                continue;
            }
            catch (Exception ex) {
                logger.warning("Could not process attribute:" + node.getAttributes().item(attributeIndex).getNodeName() + ". Error:" + ex.getMessage());
            }
        }
    }

    private void populateAttribute(Object entity, Node node, String name) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (int attributeIndex = 0; attributeIndex < node.getAttributes().getLength(); ++attributeIndex) {
            if (!name.equals(node.getAttributes().item(attributeIndex).getNodeName())) continue;
            PropertyUtils.setProperty((Object)entity, (String)node.getAttributes().item(attributeIndex).getNodeName(), (Object)node.getAttributes().item(attributeIndex).getNodeValue());
            break;
        }
    }

    private Object getAttribute(Node node, String name) throws DOMException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (int attributeIndex = 0; attributeIndex < node.getAttributes().getLength(); ++attributeIndex) {
            if (!name.equals(node.getAttributes().item(attributeIndex).getNodeName())) continue;
            return node.getAttributes().item(attributeIndex).getNodeValue();
        }
        return null;
    }
}

