/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.wsdl;

import java.util.ArrayList;
import java.util.List;
import org.mule.devkit.wsdl.Address;
import org.mule.devkit.wsdl.Binding;
import org.mule.devkit.wsdl.Identifiable;
import org.mule.devkit.wsdl.Message;
import org.mule.devkit.wsdl.ObjectType;
import org.mule.devkit.wsdl.Operation;
import org.mule.devkit.wsdl.Part;
import org.mule.devkit.wsdl.Port;
import org.mule.devkit.wsdl.PortType;
import org.mule.devkit.wsdl.Schema;
import org.mule.devkit.wsdl.Service;

public class Definition
implements Identifiable {
    private String fileName;
    private List<Schema> schemas;
    private List<PortType> portTypes;
    private List<Binding> bindings;
    private List<Message> messages;
    private List<Service> services;

    public List<Binding> getBindings() {
        if (this.bindings == null) {
            this.bindings = new ArrayList<Binding>();
        }
        return this.bindings;
    }

    public void setBindings(List<Binding> bindings) {
        this.bindings = bindings;
    }

    public void addBinding(Binding binding) {
        this.getBindings().add(binding);
    }

    public List<Service> getServices() {
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public List<PortType> getPortTypes() {
        if (this.portTypes == null) {
            this.portTypes = new ArrayList<PortType>();
        }
        return this.portTypes;
    }

    public void setPortTypes(List<PortType> portTypes) {
        this.portTypes = portTypes;
    }

    public void addPortType(PortType portType) {
        this.getPortTypes().add(portType);
    }

    public Address getAddressByPortType(String portTypeName) {
        String binding = null;
        for (Binding bd : this.getBindings()) {
            if (!bd.getType().endsWith(portTypeName)) continue;
            binding = bd.getName();
            break;
        }
        if (binding == null) {
            return null;
        }
        Address address = null;
        block1: for (Service service : this.getServices()) {
            for (Port port : service.getPorts()) {
                if (!port.getBinding().endsWith(binding)) continue;
                address = port.getAddress();
                continue block1;
            }
        }
        return address;
    }

    public List<ObjectType> getParametersFromMessage(String name) {
        Operation operation = null;
        for (PortType pt : this.getPortTypes()) {
            for (Operation op : pt.getOperations()) {
                if (!op.getName().equals(name)) continue;
                operation = op;
            }
        }
        String messageName = operation.getInput().getMessage();
        String localName = messageName.contains(":") ? messageName.substring(messageName.indexOf(":") + 1) : messageName;
        Message message = null;
        for (Message m : this.getMessages()) {
            if (!m.getName().equals(localName)) continue;
            message = m;
            break;
        }
        List<Part> list = message.getPart();
        ArrayList<ObjectType> types = new ArrayList<ObjectType>();
        for (Part p : list) {
            String partName = p.getElement();
            String local = partName.contains(":") ? partName.substring(partName.indexOf(":") + 1) : partName;
            for (Schema sc : this.getSchemas()) {
                for (ObjectType type : sc.getTypes()) {
                    if (!type.getName().equals(local)) continue;
                    types.add(type);
                }
            }
        }
        return types;
    }

    public Operation getOperationByName(String name) {
        for (PortType pt : this.getPortTypes()) {
            for (Operation op : pt.getOperations()) {
                if (!op.getName().equals(name)) continue;
                return op;
            }
        }
        return null;
    }

    public List<ObjectType> getOutputFromMessage(String name) {
        Operation operation = null;
        for (PortType pt : this.getPortTypes()) {
            for (Operation op : pt.getOperations()) {
                if (!op.getName().equals(name)) continue;
                operation = op;
            }
        }
        String messageName = operation.getOutput().getMessage();
        String localName = messageName.contains(":") ? messageName.substring(messageName.indexOf(":") + 1) : messageName;
        Message message = null;
        for (Message m : this.getMessages()) {
            if (!m.getName().equals(localName)) continue;
            message = m;
            break;
        }
        List<Part> list = message.getPart();
        ArrayList<ObjectType> types = new ArrayList<ObjectType>();
        for (Part p : list) {
            String partName = p.getElement();
            String local = partName.contains(":") ? partName.substring(partName.indexOf(":") + 1) : partName;
            for (Schema sc : this.getSchemas()) {
                for (ObjectType type : sc.getTypes()) {
                    if (!type.getName().equals(local)) continue;
                    types.add(type);
                }
            }
        }
        return types;
    }

    public List<Schema> getSchemas() {
        if (this.schemas == null) {
            this.schemas = new ArrayList<Schema>();
        }
        return this.schemas;
    }

    public void setSchemas(List<Schema> schemas) {
        this.schemas = schemas;
    }

    public List<Message> getMessages() {
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        return this.messages;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void addMessage(Message message) {
        this.getMessages().add(message);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getId() {
        return this.getFileName();
    }
}

