/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.wsdl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.devkit.wsdl.Binding;
import org.mule.devkit.wsdl.Definition;
import org.mule.devkit.wsdl.Diff;
import org.mule.devkit.wsdl.Identifiable;
import org.mule.devkit.wsdl.ObjectType;
import org.mule.devkit.wsdl.Operation;
import org.mule.devkit.wsdl.Schema;
import org.mule.devkit.wsdl.Service;

public class DefinitionDiff
implements Diff<String, Definition> {
    @Override
    public String getDiff(Definition firstObject, Definition secondObject) {
        StringBuilder output = new StringBuilder();
        Map<String, Service> first = this.populateMap(firstObject.getServices());
        Map<String, Service> second = this.populateMap(secondObject.getServices());
        this.serviceDiff(firstObject, secondObject, output, first, second);
        this.serviceDiff(secondObject, firstObject, output, second, first);
        Map<String, Binding> firstOp = this.populateMap(firstObject.getBindings());
        Map<String, Binding> secondOp = this.populateMap(secondObject.getBindings());
        this.diffBinding(firstObject, secondObject, output, firstOp, secondOp);
        this.diffBinding(secondObject, firstObject, output, secondOp, firstOp);
        Map<String, Schema> firstSch = this.populateMap(firstObject.getSchemas());
        Map<String, Schema> secondSch = this.populateMap(secondObject.getSchemas());
        this.diffSchema(firstObject, secondObject, output, firstSch, secondSch);
        this.diffSchema(secondObject, firstObject, output, secondSch, firstSch);
        return output.toString();
    }

    private void diffSchema(Definition firstObject, Definition secondObject, StringBuilder output, Map<String, Schema> secondSch, Map<String, Schema> firstSch) {
        for (String key : firstSch.keySet()) {
            if (secondSch.containsKey(key)) {
                Map<String, ObjectType> firstOpp = this.populateMap(firstSch.get(key).getTypes());
                Map<String, ObjectType> secondOpp = this.populateMap(secondSch.get(key).getTypes());
                for (String keyop : firstOpp.keySet()) {
                    if (secondOpp.containsKey(keyop)) {
                        Map<String, ObjectType> firstElement = this.populateMap(firstOpp.get(keyop).getInnerObjectType());
                        Map<String, ObjectType> seconElement = this.populateMap(secondOpp.get(keyop).getInnerObjectType());
                        for (String keyType : firstElement.keySet()) {
                            if (seconElement.containsKey(keyType)) continue;
                            output.append("++++" + this.getFormattedOutput(firstObject, secondObject) + "\t" + keyop + "\tField: " + keyType + "\n");
                            output.append("----" + this.getFormattedOutput(secondObject, firstObject) + "\t" + keyop + "\tField: " + keyType + "\n");
                        }
                        continue;
                    }
                    output.append("++++" + this.getFormattedOutput(secondObject, firstObject) + "\tType: " + keyop + "\n");
                    output.append("----" + this.getFormattedOutput(firstObject, secondObject) + "\tType: " + keyop + "\n");
                }
                continue;
            }
            output.append("++++" + this.getFormattedOutput(firstObject, secondObject) + "\tService: " + key + "\n");
            output.append("----" + this.getFormattedOutput(secondObject, firstObject) + "\tService: " + key + "\n");
        }
    }

    private String getFormattedOutput(Definition firstObject, Definition secondObject) {
        StringBuilder builder = new StringBuilder();
        int maxsize = firstObject.getId().length() > secondObject.getId().length() ? firstObject.getId().length() : secondObject.getId().length();
        builder.append(firstObject.getId());
        while (builder.length() < maxsize) {
            builder.append(" ");
        }
        return builder.toString();
    }

    protected void serviceDiff(Definition firstObject, Definition secondObject, StringBuilder output, Map<String, Service> first, Map<String, Service> second) {
        for (String key : first.keySet()) {
            if (second.containsKey(key)) continue;
            output.append("++++" + firstObject.getId() + " Service: " + key + "\n");
            output.append("----" + secondObject.getId() + " Service: " + key + "\n");
        }
    }

    protected void diffBinding(Definition firstObject, Definition secondObject, StringBuilder output, Map<String, Binding> firstOp, Map<String, Binding> secondOp) {
        for (String key : firstOp.keySet()) {
            if (secondOp.containsKey(key)) {
                Map<String, Operation> firstOpp = this.populateMap(firstOp.get(key).getOperations());
                Map<String, Operation> secondOpp = this.populateMap(secondOp.get(key).getOperations());
                for (String keyop : firstOpp.keySet()) {
                    if (secondOpp.containsKey(keyop)) continue;
                    output.append("++++" + this.getFormattedOutput(firstObject, secondObject) + "\tOperation: " + keyop + "\n");
                    output.append("----" + this.getFormattedOutput(secondObject, firstObject) + "\tOperation: " + keyop + "\n");
                }
                continue;
            }
            output.append("++++" + firstObject.getId() + "\tService:\t" + key + "\n");
            output.append("----" + secondObject.getId() + "\tService:\t" + key + "\n");
        }
    }

    private <T extends Identifiable> Map<String, T> populateMap(List<T> list) {
        HashMap<String, Identifiable> map = new HashMap<String, Identifiable>();
        for (Identifiable t : list) {
            map.put(t.getId(), t);
        }
        return map;
    }
}

