/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.3.7.0.internal.lic.validator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.devkit.3.7.0.internal.lic.InvalidLicenseException;
import org.mule.devkit.3.7.0.internal.lic.validator.LicenseValidator;

public class DefaultValidator
implements LicenseValidator {
    private static final Logger logger = LogManager.getLogger(DefaultValidator.class);
    private static final String LICENSE_MANAGEMENT_FACTORY = "com.mulesource.licm.LicenseManagementFactory";
    private static final String ENTERPRISE_LICENSE_KEY = "com.mulesource.licm.EnterpriseLicenseKey";
    private static final String FEATURE_VALIDATOR = "com.mulesource.licm.feature.FeatureValidator";
    private static final String LICENSE_MANAGER = "com.mulesource.licm.LicenseManager";
    private static final String FEATURE = "com.mulesource.licm.feature.Feature";
    private static final String MULE_EE = "mule-ee";
    private static final String EXPIRED_LICENSE_MSG = "Your license has expired";
    private final String DEFAULT_EXCEPTION_MSG;
    private final String EVALUATION_LICENSE_MSG;
    private Object license;

    public DefaultValidator(String moduleName) {
        this.DEFAULT_EXCEPTION_MSG = String.format("The Module %s requires an Enterprise License. Switch to a Mule-EE runtime to enable it.", moduleName);
        this.EVALUATION_LICENSE_MSG = String.format("The Module %s does not allow Evaluation Licenses", moduleName);
        try {
            Class<?> licManagerFactory = Class.forName(LICENSE_MANAGEMENT_FACTORY);
            Object licFactory = this.invoke(licManagerFactory.getMethod("getInstance", new Class[0]), null, new Object[0]);
            Object licenseManager = this.invoke(licManagerFactory.getMethod("createLicenseManager", String.class), licFactory, MULE_EE);
            this.license = this.invoke(Class.forName(LICENSE_MANAGER).getMethod("validate", String.class), licenseManager, MULE_EE);
        }
        catch (NoSuchMethodException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new InvalidLicenseException(this.DEFAULT_EXCEPTION_MSG);
        }
        catch (ClassNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new InvalidLicenseException(this.DEFAULT_EXCEPTION_MSG);
        }
    }

    @Override
    public void checkEnterpriseLicense(boolean allowEvaluation) {
        Calendar expirationDate = Calendar.getInstance();
        try {
            Class<?> licenseKeyClass = Class.forName(ENTERPRISE_LICENSE_KEY);
            Object expirationTime = this.invoke(licenseKeyClass.getMethod("getExpirationDate", new Class[0]), this.license, new Object[0]);
            if (expirationTime != null) {
                expirationDate.setTime((Date)expirationTime);
                if (expirationDate.after(new Date())) {
                    throw new InvalidLicenseException(EXPIRED_LICENSE_MSG);
                }
            }
            Boolean isEvaluation = (Boolean)this.invoke(licenseKeyClass.getMethod("isEvaluation", new Class[0]), this.license, new Object[0]);
            if (!allowEvaluation && isEvaluation.booleanValue()) {
                throw new InvalidLicenseException(this.EVALUATION_LICENSE_MSG);
            }
        }
        catch (NoSuchMethodException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new InvalidLicenseException(this.DEFAULT_EXCEPTION_MSG);
        }
        catch (ClassNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new InvalidLicenseException(this.DEFAULT_EXCEPTION_MSG);
        }
    }

    @Override
    public void checkEntitlement(String id, String description) {
        try {
            Class<?> featureValidatorClass = Class.forName(FEATURE_VALIDATOR);
            Class<?> featureClass = Class.forName(FEATURE);
            Constructor<?> validatorConstructor = featureValidatorClass.getConstructor(featureClass);
            Object feature = featureClass.getConstructor(String.class, String.class).newInstance(id, description);
            this.invoke(featureValidatorClass.getMethod("validate", Class.forName(ENTERPRISE_LICENSE_KEY)), validatorConstructor.newInstance(feature), this.license);
        }
        catch (InvocationTargetException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new InvalidLicenseException(this.DEFAULT_EXCEPTION_MSG);
        }
        catch (NoSuchMethodException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new InvalidLicenseException(this.DEFAULT_EXCEPTION_MSG);
        }
        catch (ClassNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new InvalidLicenseException(this.DEFAULT_EXCEPTION_MSG);
        }
        catch (IllegalAccessException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new InvalidLicenseException(this.DEFAULT_EXCEPTION_MSG);
        }
        catch (InstantiationException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new InvalidLicenseException(this.DEFAULT_EXCEPTION_MSG);
        }
    }

    private Object invoke(Method method, Object instance, Object ... args) {
        return this.invoke(this.DEFAULT_EXCEPTION_MSG, method, instance, args);
    }

    private Object invoke(String msgOnException, Method method, Object instance, Object ... args) {
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            throw new InvalidLicenseException(msgOnException, e);
        }
        catch (InvocationTargetException e) {
            throw new InvalidLicenseException(msgOnException, e);
        }
    }
}

