/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.siebel.businessservice.config;

import org.mule.config.MuleManifest;
import org.mule.modules.siebel.businessservice.config.ExecuteBusinessServiceDefinitionParser;
import org.mule.modules.siebel.businessservice.config.ExecuteDefinitionParser;
import org.mule.modules.siebel.businessservice.config.SiebelBusServiceConnectorSiebelBasicAuthStrategyConfigDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class SiebelBsNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(SiebelBsNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [siebel-bs] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [siebel-bs] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new SiebelBusServiceConnectorSiebelBasicAuthStrategyConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("execute", (BeanDefinitionParser)new ExecuteDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("execute", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("execute-business-service", (BeanDefinitionParser)new ExecuteBusinessServiceDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("execute-business-service", "@Processor", ex);
        }
    }
}

