/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.siebel.metadata;

import com.siebel.data.SiebelException;
import com.siebel.data.SiebelPropertySet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.mule.common.metadata.DefaultDefinedMapMetaDataModel;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataField;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.modules.siebel.api.SiebelDataBeanClient;
import org.mule.modules.siebel.api.model.SiebelBusinessServiceMethodArgType;
import org.mule.modules.siebel.businessservice.SiebelBusServiceConnector;
import org.mule.modules.siebel.util.BusCompQuery;
import org.mule.modules.siebel.util.SiebelConnectorUtils;

public class BusinessServiceCategory {
    @Inject
    private SiebelBusServiceConnector connector;

    public List<MetaDataKey> getMetadataKeys() throws SiebelException {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("Id");
        fields.add("Name");
        BusCompQuery query = new BusCompQuery(this.connector.getStrategy().getClient(), "Repository Details.Repository Business Service");
        query.setFieldsToRetrieve(fields).setSearchExpression(this.connector.getDataSenseFilterQuery()).setViewMode(Integer.valueOf(3));
        List businessServices = query.executeQuery();
        BusCompQuery queryServiceMethods = new BusCompQuery(this.connector.getStrategy().getClient(), "Repository Business Service.Repository Business Service Method");
        queryServiceMethods.setFieldsToRetrieve(fields).setViewMode(Integer.valueOf(3));
        ArrayList<MetaDataKey> keys = new ArrayList<MetaDataKey>();
        for (Map businessService : businessServices) {
            HashMap<String, String> searchSpec = new HashMap<String, String>();
            searchSpec.put("Parent Id", (String)businessService.get("Id"));
            List businessServiceMethods = queryServiceMethods.setSearchSpecification(searchSpec).executeQuery();
            for (Map businessMethod : businessServiceMethods) {
                String compositeName = businessService.get("Name") + "." + businessMethod.get("Name");
                keys.add((MetaDataKey)new DefaultMetaDataKey(compositeName, compositeName));
            }
        }
        return keys;
    }

    public MetaData getOutputMetaData(MetaDataKey key) throws SiebelException {
        return this.getMetaData(key);
    }

    public MetaData getMetaData(MetaDataKey key) throws SiebelException {
        List<Map<String, Object>> businessServiceMethodArgs = this.getBusinessServiceMethodArgs(key.getId(), null);
        DefaultMetaData metaData = null;
        if (businessServiceMethodArgs != null) {
            ArrayList<DefaultMetaDataField> list = new ArrayList<DefaultMetaDataField>(businessServiceMethodArgs.size());
            for (Map<String, Object> businessServiceMethodArg : businessServiceMethodArgs) {
                String fieldName = (String)businessServiceMethodArg.get("Name");
                if (businessServiceMethodArg.get("Type").equals(SiebelBusinessServiceMethodArgType.OUTPUT.toString())) {
                    fieldName = "(Output) " + fieldName;
                }
                if (StringUtils.isBlank((String)((String)businessServiceMethodArg.get("Integration Object")))) {
                    DefaultMetaDataField fieldModel = new DefaultMetaDataField(fieldName, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.STRING));
                    list.add(fieldModel);
                    continue;
                }
                SiebelPropertySet integrationObjectMessage = SiebelConnectorUtils.createEmptyPropertySetFromIntegrationObject((SiebelDataBeanClient)this.connector.getStrategy().getClient(), (String)((String)businessServiceMethodArg.get("Integration Object"))).getChild(0);
                DefaultMetaDataField fieldModel = new DefaultMetaDataField(fieldName, (MetaDataModel)new DefaultDefinedMapMetaDataModel(SiebelConnectorUtils.getMetaDataFieldFromMap((Map)SiebelConnectorUtils.propertySetToMap((SiebelPropertySet)integrationObjectMessage)), fieldName));
                list.add(fieldModel);
            }
            DefaultDefinedMapMetaDataModel model = new DefaultDefinedMapMetaDataModel(list, key.getId());
            metaData = new DefaultMetaData((MetaDataModel)model);
        }
        return metaData;
    }

    private List<Map<String, Object>> getBusinessServiceMethodArgs(String businessServiceFullName, String fieldSearchQuery) throws SiebelException {
        ArrayList<String> fieldsToRetrieve = new ArrayList<String>();
        fieldsToRetrieve.add("Id");
        HashMap<String, String> searchSpec = new HashMap<String, String>();
        searchSpec.put("Parent Name", SiebelConnectorUtils.extractBusinessServiceName((String)businessServiceFullName));
        searchSpec.put("Name", SiebelConnectorUtils.extractBusinessServiceMethodName((String)businessServiceFullName));
        BusCompQuery query = new BusCompQuery(this.connector.getStrategy().getClient(), "Repository Details.Repository Business Service Method");
        query.setFieldsToRetrieve(fieldsToRetrieve).setSearchSpecification(searchSpec).setViewMode(Integer.valueOf(this.connector.getDefaultViewMode()));
        String businessServiceMethodId = (String)((Map)query.executeQuery().get(0)).get("Id");
        fieldsToRetrieve.clear();
        fieldsToRetrieve.add("Parent Id");
        fieldsToRetrieve.add("Name");
        fieldsToRetrieve.add("Type");
        fieldsToRetrieve.add("Integration Object");
        fieldsToRetrieve.add("Data Type");
        String searchQuery = String.format("([Parent Id] = '%s' AND [Inactive] = 'N')", businessServiceMethodId);
        if (fieldSearchQuery != null) {
            searchQuery = searchQuery + " AND (" + fieldSearchQuery + ")";
        }
        query = new BusCompQuery(this.connector.getStrategy().getClient(), "Repository Details.Repository Business Service Method Arg");
        query.setFieldsToRetrieve(fieldsToRetrieve).setSearchExpression(searchQuery).setViewMode(Integer.valueOf(this.connector.getDefaultViewMode()));
        return query.executeQuery();
    }

    public SiebelBusServiceConnector getConnector() {
        return this.connector;
    }

    public void setConnector(SiebelBusServiceConnector connector) {
        this.connector = connector;
    }
}

