/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.siebel.businessservice;

import com.siebel.data.SiebelException;
import org.apache.commons.lang.Validate;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.modules.siebel.api.DefaultSiebelDataBeanClient;
import org.mule.modules.siebel.api.SiebelDataBeanClient;

public class Config {
    protected SiebelDataBeanClient client;
    protected String user;
    private int defaultViewMode;
    private String dataSenseFilterQuery;

    public void connect(boolean rsaEnabled, String user, String password, String server, String port, String serverName, String objectManager, String language, String encoding) throws ConnectionException {
        Validate.notNull((Object)user, (String)"The attribute 'User' cannot be null");
        Validate.notNull((Object)password, (String)"The attribute 'Password' cannot be null");
        Validate.notNull((Object)server, (String)"You have to specify a Server address in your config");
        Validate.notNull((Object)serverName, (String)"You have to specify a Siebel server name in your config");
        Validate.notNull((Object)objectManager, (String)"You have to specify a Siebel Object Manager in your config");
        this.client = new DefaultSiebelDataBeanClient();
        this.user = user + "@" + server;
        if (encoding != null) {
            System.setProperty("file.encoding", encoding);
        }
        try {
            this.client.login(server, port, serverName, objectManager, user, password, language, rsaEnabled);
        }
        catch (SiebelException e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, "Cannot connect to Siebel server", (Throwable)e);
        }
    }

    public void disconnect() throws RuntimeException {
        try {
            this.client.logoff();
            this.client = null;
        }
        catch (SiebelException e) {
            throw new RuntimeException(e.getErrorMessage(), e);
        }
    }

    public boolean isConnected() {
        return this.client != null;
    }

    public String connectionId() {
        return this.user;
    }

    public SiebelDataBeanClient getClient() {
        return this.client;
    }

    public String getUser() {
        return this.user;
    }

    public int getDefaultViewMode() {
        return this.defaultViewMode;
    }

    public void setDefaultViewMode(int defaultViewMode) {
        this.defaultViewMode = defaultViewMode;
    }

    public String getDataSenseFilterQuery() {
        return this.dataSenseFilterQuery;
    }

    public void setDataSenseFilterQuery(String dataSenseFilterQuery) {
        this.dataSenseFilterQuery = dataSenseFilterQuery;
    }
}

