/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.git;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.File;
import java.util.stream.Collectors;
import org.apache.maven.project.MavenProject;
import org.mule.tools.devkit.sonar.checks.git.GitCheck;
import org.mule.tools.devkit.sonar.exception.SonarCheckException;
import org.mule.tools.devkit.sonar.utils.PomUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultIndexedFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.check.Rule;

public class GitSensor
implements Sensor {
    private Iterable<Class<?>> checks = new Reflections("org.mule.tools.devkit.sonar.checks.git", new Scanner[0]).getTypesAnnotatedWith(Rule.class).stream().filter(arg_0 -> ((Predicate)Predicates.subtypeOf(GitCheck.class)).apply(arg_0)).collect(Collectors.toList());

    public void describe(SensorDescriptor sensorDescriptor) {
    }

    public void execute(SensorContext sensorContext) {
        try {
            FileSystem fileSystem = sensorContext.fileSystem();
            MavenProject mavenProject = PomUtils.createMavenProjectFromPomFile(fileSystem.baseDir());
            if (PomUtils.isDevKitConnector(mavenProject)) {
                File baseDir = sensorContext.fileSystem().baseDir();
                File file = new File(baseDir.getAbsolutePath() + File.separator + ".gitignore");
                if (!file.exists()) {
                    throw new SonarCheckException(String.format("Not found %s file, needed to %s analyze", ".gitignore", "git"));
                }
                DefaultIndexedFile dif = new DefaultIndexedFile(sensorContext.project().key(), baseDir.toPath(), file.getAbsolutePath(), "git");
                DefaultInputFile inp = new DefaultInputFile(dif, null);
                for (Class<?> check : this.checks) {
                    ((GitCheck)GitCheck.class.cast(check.newInstance())).analyse(sensorContext, (InputFile)inp);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SonarCheckException(e);
        }
    }
}

