/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.collect.Iterables;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.sonar.checks.java.AbstractConnectorClassCheck;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="devkit-annotations-order", name="DevKit annotations should be added in a certain order for easing readability", description="If there is a @Default or @Optional annotation, it should be the last one (closest to the argument declaration). If there is @RefOnly, it should be prior to @Default or @Optional.", priority=Priority.CRITICAL, tags={"connector-certification"})
public class DevKitAnnotationsOrderCheck
extends AbstractConnectorClassCheck {
    public static final String KEY = "devkit-annotations-order";

    @Override
    protected void verifyProcessor(@NotNull MethodTree tree, @NotNull IdentifierTree processorAnnotation) {
        for (VariableTree var : tree.parameters()) {
            List annotations = var.modifiers().annotations();
            int indexOfDefault = Iterables.indexOf((Iterable)annotations, ClassParserUtils.hasAnnotationPredicate("org.mule.api.annotations.param.Default"));
            int indexOfOptional = Iterables.indexOf((Iterable)annotations, ClassParserUtils.hasAnnotationPredicate("org.mule.api.annotations.param.Optional"));
            int indexOfRefOnly = Iterables.indexOf((Iterable)annotations, ClassParserUtils.hasAnnotationPredicate("org.mule.api.annotations.param.RefOnly"));
            if (this.hasAnnotation(indexOfDefault) && this.isNotLastAnnotation(indexOfDefault, annotations)) {
                this.logAndRaiseIssue((Tree)annotations.get(indexOfDefault), String.format("@Default annotation must be the last one in method '%s' argument '%s'.", tree.simpleName(), var.simpleName()));
                continue;
            }
            if (this.hasAnnotation(indexOfOptional) && this.isNotLastAnnotation(indexOfOptional, annotations)) {
                this.logAndRaiseIssue((Tree)annotations.get(indexOfOptional), String.format("@Optional annotation must be the last one in method '%s' argument '%s'.", tree.simpleName(), var.simpleName()));
                continue;
            }
            if (this.hasAnnotation(indexOfRefOnly) && !this.hasDefaultOrOptional(indexOfDefault, indexOfOptional) && this.isNotLastAnnotation(indexOfRefOnly, annotations)) {
                this.logAndRaiseIssue((Tree)annotations.get(indexOfRefOnly), String.format("@RefOnly annotation must be the last one in method '%s' argument '%s'.", tree.simpleName(), var.simpleName()));
                continue;
            }
            if (!this.hasAnnotation(indexOfRefOnly) || !this.hasDefaultOrOptional(indexOfDefault, indexOfOptional) || !this.isNotNextToLastAnnotation(indexOfRefOnly, annotations)) continue;
            this.logAndRaiseIssue((Tree)annotations.get(indexOfRefOnly), String.format("@RefOnly annotation must be placed just before @Default in method '%s' argument '%s'.", tree.simpleName(), var.simpleName()));
        }
    }

    private boolean hasDefaultOrOptional(int indexOfDefault, int indexOfOptional) {
        return this.hasAnnotation(indexOfDefault) || this.hasAnnotation(indexOfOptional);
    }

    private boolean hasAnnotation(int index) {
        return index != -1;
    }

    private boolean isNotLastAnnotation(int index, List<AnnotationTree> annotations) {
        return index != annotations.size() - 1;
    }

    private boolean isNotNextToLastAnnotation(int index, List<AnnotationTree> annotations) {
        return index != annotations.size() - 2;
    }
}

