/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.collect.Iterables;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.sonar.checks.java.AbstractConnectorClassCheck;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="devkit-redundant-annotations", name="DevKit annotations @Default and @Optional should not be used at the same time in the same processor argument.", description="When using @Default, the @Optional annotation is redundant (@Default implies @Optional). The recommended approach is to discard the @Optional.", priority=Priority.CRITICAL, tags={"connector-certification"})
public class DevKitRedundantAnnotationsCheck
extends AbstractConnectorClassCheck {
    public static final String KEY = "devkit-redundant-annotations";

    @Override
    protected void verifyProcessor(@NotNull MethodTree tree, @NotNull IdentifierTree processorAnnotation) {
        for (VariableTree var : tree.parameters()) {
            List annotations = var.modifiers().annotations();
            if (!Iterables.any((Iterable)annotations, ClassParserUtils.hasAnnotationPredicate("org.mule.api.annotations.param.Default")) || !Iterables.any((Iterable)annotations, ClassParserUtils.hasAnnotationPredicate("org.mule.api.annotations.param.Optional"))) continue;
            this.logAndRaiseIssue((Tree)tree.simpleName(), String.format("@Default and @Optional annotations cannot be used at the same time in method '%s' argument '%s'. Discard @Optional.", tree.simpleName(), var.simpleName()));
        }
    }
}

